"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderPopoverContent = TimeSliderPopoverContent;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _time_slider_strings = require("./time_slider_strings");
var _time_slider_anchored_range = require("./time_slider_anchored_range");
var _time_slider_sliding_window_range = require("./time_slider_sliding_window_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function TimeSliderPopoverContent(props) {
  const rangeInput = props.isAnchored ? /*#__PURE__*/_react.default.createElement(_time_slider_anchored_range.TimeSliderAnchoredRange, {
    value: props.value,
    onChange: props.onChange,
    stepSize: props.stepSize,
    ticks: props.ticks,
    timeRangeMin: props.timeRangeMin,
    timeRangeMax: props.timeRangeMax,
    compressed: props.compressed
  }) : /*#__PURE__*/_react.default.createElement(_time_slider_sliding_window_range.TimeSliderSlidingWindowRange, {
    value: props.value,
    onChange: props.onChange,
    stepSize: props.stepSize,
    ticks: props.ticks,
    timeRangeMin: props.timeRangeMin,
    timeRangeMax: props.timeRangeMax,
    compressed: props.compressed
  });
  const anchorStartToggleButtonLabel = props.isAnchored ? _time_slider_strings.TimeSliderStrings.control.getUnpinStart() : _time_slider_strings.TimeSliderStrings.control.getPinStart();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "rangeSlider__actions",
    gutterSize: "none",
    "data-test-subj": "timeSlider-popoverContents",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: anchorStartToggleButtonLabel,
    position: "left"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: props.isAnchored ? 'pinFilled' : 'pin',
    onClick: () => {
      const nextIsAnchored = !props.isAnchored;
      if (nextIsAnchored) {
        props.onChange([props.timeRangeMin, props.value[1]]);
      }
      props.setIsAnchored(nextIsAnchored);
    },
    "aria-label": anchorStartToggleButtonLabel,
    "data-test-subj": "timeSlider__anchorStartToggleButton"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, rangeInput));
}