"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeRangeControlSelections = initializeRangeControlSelections;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeRangeControlSelections(initialState, onSelectionChange) {
  const value$ = new _rxjs.BehaviorSubject(initialState.value);
  function setValue(next) {
    if (value$.value !== next) {
      value$.next(next);
      onSelectionChange();
    }
  }
  return {
    comparators: {
      value: [value$, setValue]
    },
    hasInitialSelections: initialState.value !== undefined,
    value$: value$,
    setValue
  };
}