"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rangeSliderControlStyles = void 0;
var _react = require("@emotion/react");
var _form = require("@elastic/eui/lib/components/form/form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// @ts-ignore - Kibana has trouble reaching into lib/components for types

const rangeSliderControlStyles = euiThemeContext => {
  const {
    euiTheme
  } = euiThemeContext;
  return {
    // Wrapper
    // NOTE: This component is used by a ControlPanel component that already sets its own
    // EuiFormControlLayout, so unfortunately there is some double nesting going on here
    // that we need to account for via height inheritence & unsetting EuiDualRange's
    // form control layout colors/borders
    rangeSliderControl: (0, _react.css)`
      &,
      .euiPopover,
      .euiFormControlLayoutDelimited {
        height: 100%;
      }

      .euiFormControlLayout {
        background-color: transparent;
        border: none;
        border-radius: 0;
      }
    `,
    invalid: (0, _react.css)`
      /* EUI CSS util for the generating the underline background-image/gradient */
      ${(0, _form.euiFormControlDefaultShadow)(euiThemeContext, {
      withBorder: false,
      withBackgroundColor: false,
      withBackgroundAnimation: true
    })}

      /* Stretch the underline across the entire __childrenWrapper and set it to a custom warning color */
      background-size: 100% 100%;
      --euiFormControlStateColor: ${euiTheme.colors.warning};

      /* But restore the danger color for truly invalid inputs (e.g. min larger than max) */
      &:has(input:invalid) {
        --euiFormControlStateColor: ${euiTheme.colors.danger};
      }

      /* Remove the append background so the caution icon looks more natural */
      .euiFormControlLayout__append {
        background-color: transparent;
      }
    `,
    // Inputs
    fieldNumbers: {
      rangeSliderFieldNumber: (0, _react.css)`
        font-weight: ${euiTheme.font.weight.medium};
        background-color: transparent;

        &:placeholder-shown,
        &::placeholder {
          font-weight: ${euiTheme.font.weight.regular};
          color: ${euiTheme.colors.subduedText};
        }
      `,
      invalid: (0, _react.css)`
        &:not(:invalid) {
          color: ${euiTheme.colors.warningText};
        }
        &:invalid {
          color: ${euiTheme.colors.dangerText};
        }
      `,
      // unset the red underline for values between steps
      valid: (0, _react.css)`
        &:invalid:not(:focus) {
          --euiFormControlStateColor: transparent;
        }
      `
    }
  };
};
exports.rangeSliderControlStyles = rangeSliderControlStyles;