"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_strings = require("../options_list_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const aggregationToggleButtons = [{
  id: 'optionsList__includeResults',
  key: 'optionsList__includeResults',
  label: _options_list_strings.OptionsListStrings.popover.getIncludeLabel()
}, {
  id: 'optionsList__excludeResults',
  key: 'optionsList__excludeResults',
  label: _options_list_strings.OptionsListStrings.popover.getExcludeLabel()
}];
const OptionsListPopoverFooter = () => {
  const {
    api,
    stateManager
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const [exclude, loading, allowExpensiveQueries] = (0, _presentationPublishing.useBatchedPublishingSubjects)(stateManager.exclude, api.dataLoading, api.parentApi.allowExpensiveQueries$);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "none",
    css: (0, _react2.css)`
          background-color: ${(0, _eui.useEuiBackgroundColor)('subdued')};
        `
  }, loading && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'absolute',
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "optionsList-control-popover-loading",
    size: "xs",
    color: "accent"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "center",
    css: (0, _react2.css)`
            padding: ${(0, _eui.useEuiPaddingSize)('s')};
          `,
    justifyContent: 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _options_list_strings.OptionsListStrings.popover.getIncludeExcludeLegend(),
    options: aggregationToggleButtons,
    idSelected: exclude ? 'optionsList__excludeResults' : 'optionsList__includeResults',
    onChange: optionId => api.setExclude(optionId === 'optionsList__excludeResults'),
    buttonSize: "compressed",
    "data-test-subj": "optionsList__includeExcludeButtonGroup"
  })), !allowExpensiveQueries && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "optionsList-allow-expensive-queries-warning",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "warning",
    color: "warning",
    content: _options_list_strings.OptionsListStrings.popover.getAllowExpensiveQueriesWarning(),
    "aria-label": _options_list_strings.OptionsListStrings.popover.getAllowExpensiveQueriesWarning()
  })))));
};
exports.OptionsListPopoverFooter = OptionsListPopoverFooter;