"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverActionBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _suggestions_searching = require("../../../../../common/options_list/suggestions_searching");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_popover_sorting_button = require("./options_list_popover_sorting_button");
var _options_list_strings = require("../options_list_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OptionsListPopoverActionBar = ({
  showOnlySelected,
  setShowOnlySelected
}) => {
  const {
    api,
    stateManager,
    displaySettings
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const [searchString, searchTechnique, searchStringValid, invalidSelections, totalCardinality, field, allowExpensiveQueries] = (0, _presentationPublishing.useBatchedPublishingSubjects)(stateManager.searchString, stateManager.searchTechnique, stateManager.searchStringValid, api.invalidSelections$, api.totalCardinality$, api.field$, api.parentApi.allowExpensiveQueries$);
  const compatibleSearchTechniques = (0, _react.useMemo)(() => {
    if (!field) return [];
    return (0, _suggestions_searching.getCompatibleSearchTechniques)(field.type);
  }, [field]);
  const defaultSearchTechnique = (0, _react.useMemo)(() => searchTechnique !== null && searchTechnique !== void 0 ? searchTechnique : compatibleSearchTechniques[0], [searchTechnique, compatibleSearchTechniques]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "optionsList__actions"
  }, compatibleSearchTechniques.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    className: "optionsList__searchRow",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    isInvalid: !searchStringValid,
    compressed: true,
    disabled: showOnlySelected,
    fullWidth: true,
    onChange: event => {
      stateManager.searchString.next(event.target.value);
    },
    value: searchString,
    "data-test-subj": "optionsList-control-search-input",
    placeholder: _options_list_strings.OptionsListStrings.popover.getSearchPlaceholder(allowExpensiveQueries ? defaultSearchTechnique : 'exact')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    className: "optionsList__actionsRow",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, allowExpensiveQueries && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    "data-test-subj": "optionsList-cardinality-label"
  }, _options_list_strings.OptionsListStrings.popover.getCardinalityLabel(totalCardinality))), invalidSelections && invalidSelections.size > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, allowExpensiveQueries && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "optionsList__actionBarDivider"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _options_list_strings.OptionsListStrings.popover.getInvalidSelectionsLabel(invalidSelections.size)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: showOnlySelected ? _options_list_strings.OptionsListStrings.popover.getAllOptionsButtonTitle() : _options_list_strings.OptionsListStrings.popover.getSelectedOptionsButtonTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "list",
    "aria-pressed": showOnlySelected,
    color: showOnlySelected ? 'primary' : 'text',
    display: showOnlySelected ? 'base' : 'empty',
    onClick: () => setShowOnlySelected(!showOnlySelected),
    "data-test-subj": "optionsList-control-show-only-selected",
    "aria-label": showOnlySelected ? _options_list_strings.OptionsListStrings.popover.getAllOptionsButtonTitle() : _options_list_strings.OptionsListStrings.popover.getSelectedOptionsButtonTitle()
  }))), !displaySettings.hideSort && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover_sorting_button.OptionsListPopoverSortingButton, {
    showOnlySelected: showOnlySelected
  })))))));
};
exports.OptionsListPopoverActionBar = OptionsListPopoverActionBar;