"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListEditorOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _suggestions_searching = require("../../../../../common/options_list/suggestions_searching");
var _control_setting_tooltip_label = require("../../../../control_group/components/control_setting_tooltip_label");
var _constants = require("../constants");
var _options_list_strings = require("../options_list_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const selectionOptions = [{
  id: 'multi',
  label: _options_list_strings.OptionsListStrings.editor.selectionTypes.multi.getLabel(),
  'data-test-subj': 'optionsListControl__multiSearchOptionAdditionalSetting'
}, {
  id: 'single',
  label: _options_list_strings.OptionsListStrings.editor.selectionTypes.single.getLabel(),
  'data-test-subj': 'optionsListControl__singleSearchOptionAdditionalSetting'
}];
const allSearchOptions = [{
  id: 'prefix',
  label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
    label: _options_list_strings.OptionsListStrings.editor.searchTypes.prefix.getLabel(),
    tooltip: _options_list_strings.OptionsListStrings.editor.searchTypes.prefix.getTooltip()
  }),
  'data-test-subj': 'optionsListControl__prefixSearchOptionAdditionalSetting'
}, {
  id: 'wildcard',
  label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
    label: _options_list_strings.OptionsListStrings.editor.searchTypes.wildcard.getLabel(),
    tooltip: _options_list_strings.OptionsListStrings.editor.searchTypes.wildcard.getTooltip()
  }),
  'data-test-subj': 'optionsListControl__wildcardSearchOptionAdditionalSetting'
}, {
  id: 'exact',
  label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
    label: _options_list_strings.OptionsListStrings.editor.searchTypes.exact.getLabel(),
    tooltip: _options_list_strings.OptionsListStrings.editor.searchTypes.exact.getTooltip()
  }),
  'data-test-subj': 'optionsListControl__exactSearchOptionAdditionalSetting'
}];
const OptionsListEditorOptions = ({
  initialState,
  field,
  updateState,
  controlGroupApi
}) => {
  var _initialState$singleS, _initialState$runPast, _initialState$searchT;
  const allowExpensiveQueries = (0, _presentationPublishing.useStateFromPublishingSubject)(controlGroupApi.allowExpensiveQueries$);
  const [singleSelect, setSingleSelect] = (0, _react.useState)((_initialState$singleS = initialState.singleSelect) !== null && _initialState$singleS !== void 0 ? _initialState$singleS : false);
  const [runPastTimeout, setRunPastTimeout] = (0, _react.useState)((_initialState$runPast = initialState.runPastTimeout) !== null && _initialState$runPast !== void 0 ? _initialState$runPast : false);
  const [searchTechnique, setSearchTechnique] = (0, _react.useState)((_initialState$searchT = initialState.searchTechnique) !== null && _initialState$searchT !== void 0 ? _initialState$searchT : _constants.DEFAULT_SEARCH_TECHNIQUE);
  const compatibleSearchTechniques = (0, _react.useMemo)(() => (0, _suggestions_searching.getCompatibleSearchTechniques)(field.type), [field.type]);
  const searchOptions = (0, _react.useMemo)(() => {
    return allSearchOptions.filter(searchOption => {
      return compatibleSearchTechniques.includes(searchOption.id);
    });
  }, [compatibleSearchTechniques]);
  (0, _react.useEffect)(() => {
    /**
     * when field type changes, ensure that the selected search technique is still valid;
     * if the selected search technique **isn't** valid, reset it to the default
     */
    const initialSearchTechniqueValid = initialState.searchTechnique && compatibleSearchTechniques.includes(initialState.searchTechnique);
    const currentSearchTechniqueValid = compatibleSearchTechniques.includes(searchTechnique);
    if (initialSearchTechniqueValid) {
      // reset back to initial state if possible on field change
      setSearchTechnique(initialState.searchTechnique);
      updateState({
        searchTechnique: initialState.searchTechnique
      });
    } else if (currentSearchTechniqueValid) {
      // otherwise, if the current selection is valid, send that to the parent editor state
      updateState({
        searchTechnique
      });
    } else {
      // finally, if neither the initial or current search technique is valid, revert to the default
      setSearchTechnique(compatibleSearchTechniques[0]);
      updateState({
        searchTechnique: compatibleSearchTechniques[0]
      });
    }

    // Note: We only want to call this when compatible search techniques changes
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [compatibleSearchTechniques]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _options_list_strings.OptionsListStrings.editor.getSelectionOptionsTitle(),
    "data-test-subj": "optionsListControl__selectionOptionsRadioGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: selectionOptions,
    idSelected: singleSelect ? 'single' : 'multi',
    onChange: id => {
      const newSingleSelect = id === 'single';
      setSingleSelect(newSingleSelect);
      updateState({
        singleSelect: newSingleSelect
      });
    }
  })), allowExpensiveQueries && compatibleSearchTechniques.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _options_list_strings.OptionsListStrings.editor.getSearchOptionsTitle(),
    "data-test-subj": "optionsListControl__searchOptionsRadioGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: searchOptions,
    idSelected: searchTechnique,
    onChange: id => {
      const newSearchTechnique = id;
      setSearchTechnique(newSearchTechnique);
      updateState({
        searchTechnique: newSearchTechnique
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _options_list_strings.OptionsListStrings.editor.getAdditionalSettingsTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
      label: _options_list_strings.OptionsListStrings.editor.getRunPastTimeoutTitle(),
      tooltip: _options_list_strings.OptionsListStrings.editor.getRunPastTimeoutTooltip()
    }),
    checked: runPastTimeout,
    onChange: () => {
      const newRunPastTimeout = !runPastTimeout;
      setRunPastTimeout(newRunPastTimeout);
      updateState({
        runPastTimeout: newRunPastTimeout
      });
    },
    "data-test-subj": 'optionsListControl__runPastTimeoutAdditionalSetting'
  })));
};
exports.OptionsListEditorOptions = OptionsListEditorOptions;