"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListControl = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _is_compressed = require("../../../../control_group/utils/is_compressed");
var _constants = require("../../../constants");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_popover = require("./options_list_popover");
var _options_list_strings = require("../options_list_strings");
require("./options_list.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OptionsListControl = ({
  controlPanelClassName
}) => {
  var _displaySettings$plac;
  const popoverId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const {
    api,
    stateManager,
    displaySettings
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [excludeSelected, existsSelected, selectedOptions, invalidSelections, field, loading, panelTitle, fieldFormatter] = (0, _presentationPublishing.useBatchedPublishingSubjects)(stateManager.exclude, stateManager.existsSelected, stateManager.selectedOptions, api.invalidSelections$, api.field$, api.dataLoading, api.panelTitle, api.fieldFormatter);
  const [defaultPanelTitle] = (0, _presentationPublishing.useBatchedOptionalPublishingSubjects)(api.defaultPanelTitle);
  const delimiter = (0, _react.useMemo)(() => _options_list_strings.OptionsListStrings.control.getSeparator(field === null || field === void 0 ? void 0 : field.type), [field]);
  const {
    hasSelections,
    selectionDisplayNode,
    selectedOptionsCount
  } = (0, _react.useMemo)(() => {
    return {
      hasSelections: !(0, _lodash.isEmpty)(selectedOptions),
      selectedOptionsCount: selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.length,
      selectionDisplayNode: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        responsive: false,
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        className: "optionsList__selections",
        "data-test-subj": "optionsListSelections"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "eui-textTruncate"
      }, excludeSelected && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        className: "optionsList__negateLabel"
      }, existsSelected ? _options_list_strings.OptionsListStrings.control.getExcludeExists() : _options_list_strings.OptionsListStrings.control.getNegate()), ' '), existsSelected ? /*#__PURE__*/_react.default.createElement("span", {
        className: `optionsList__existsFilter`
      }, _options_list_strings.OptionsListStrings.controlAndPopover.getExists(+Boolean(excludeSelected))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedOptions !== null && selectedOptions !== void 0 && selectedOptions.length ? selectedOptions.map((value, i, {
        length
      }) => {
        const text = `${fieldFormatter(value)}${i + 1 === length ? '' : delimiter} `;
        const isInvalid = invalidSelections === null || invalidSelections === void 0 ? void 0 : invalidSelections.has(value);
        return /*#__PURE__*/_react.default.createElement("span", {
          key: value,
          className: `optionsList__filter ${isInvalid ? 'optionsList__filterInvalid' : ''}`
        }, text);
      }) : null))), invalidSelections && invalidSelections.size > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _options_list_strings.OptionsListStrings.control.getInvalidSelectionWarningLabel(invalidSelections.size),
        delay: "long"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
        tabIndex: 0,
        iconType: "alert",
        size: "s",
        color: "euiColorVis5",
        shape: "square",
        fill: "dark",
        title: _options_list_strings.OptionsListStrings.control.getInvalidSelectionWarningLabel(invalidSelections.size),
        "data-test-subj": `optionsList__invalidSelectionsToken-${api.uuid}`,
        css: {
          verticalAlign: 'text-bottom'
        } // Align with the notification badge
      }))))
    };
  }, [selectedOptions, excludeSelected, existsSelected, fieldFormatter, delimiter, invalidSelections, api.uuid]);
  const button = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    badgeColor: "success",
    iconType: loading ? 'empty' : 'arrowDown',
    className: 'optionsList--filterBtn',
    "data-test-subj": `optionsList-control-${api.uuid}`,
    onClick: () => setPopoverOpen(!isPopoverOpen),
    isSelected: isPopoverOpen,
    numActiveFilters: selectedOptionsCount,
    hasActiveFilters: Boolean(selectedOptionsCount),
    textProps: {
      className: 'optionsList--selectionText'
    },
    "aria-label": panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle,
    "aria-expanded": isPopoverOpen,
    "aria-controls": popoverId,
    role: "combobox"
  }, hasSelections || existsSelected ? selectionDisplayNode : (_displaySettings$plac = displaySettings.placeholder) !== null && _displaySettings$plac !== void 0 ? _displaySettings$plac : _options_list_strings.OptionsListStrings.control.getPlaceholder()));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    fullWidth: true,
    compressed: (0, _is_compressed.isCompressed)(api),
    className: controlPanelClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    id: popoverId,
    ownFocus: true,
    input: button,
    hasArrow: false,
    repositionOnScroll: true,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    panelMinWidth: _constants.MIN_POPOVER_WIDTH,
    className: "optionsList__inputButtonOverride",
    initialFocus: '[data-test-subj=optionsList-control-search-input]',
    closePopover: () => setPopoverOpen(false),
    panelClassName: "optionsList__popoverOverride",
    panelProps: {
      title: panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle,
      'aria-label': _options_list_strings.OptionsListStrings.popover.getAriaLabel(panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle)
    }
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover.OptionsListPopover, null)));
};
exports.OptionsListControl = OptionsListControl;