"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroupStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ControlGroupStrings = exports.ControlGroupStrings = {
  getSaveChangesTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.saveChangesTitle', {
    defaultMessage: 'Save and close'
  }),
  getCancelTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.cancelTitle', {
    defaultMessage: 'Cancel'
  }),
  management: {
    getApplyButtonTitle: hasUnappliedSelections => hasUnappliedSelections ? _i18n.i18n.translate('controls.controlGroup.management.applyButtonTooltip.enabled', {
      defaultMessage: 'Apply selections'
    }) : _i18n.i18n.translate('controls.controlGroup.management.applyButtonTooltip.disabled', {
      defaultMessage: 'No new selections to apply'
    }),
    getFlyoutTitle: () => _i18n.i18n.translate('controls.controlGroup.management.flyoutTitle', {
      defaultMessage: 'Control settings'
    }),
    getDeleteAllButtonTitle: () => _i18n.i18n.translate('controls.controlGroup.management.deleteAll', {
      defaultMessage: 'Delete all'
    }),
    labelPosition: {
      getLabelPositionTitle: () => _i18n.i18n.translate('controls.controlGroup.management.labelPosition.title', {
        defaultMessage: 'Label position'
      }),
      getLabelPositionLegend: () => _i18n.i18n.translate('controls.controlGroup.management.labelPosition.designSwitchLegend', {
        defaultMessage: 'Switch label position between inline and above'
      }),
      getInlineTitle: () => _i18n.i18n.translate('controls.controlGroup.management.labelPosition.inline', {
        defaultMessage: 'Inline'
      }),
      getAboveTitle: () => _i18n.i18n.translate('controls.controlGroup.management.labelPosition.above', {
        defaultMessage: 'Above'
      })
    },
    selectionSettings: {
      getSelectionSettingsTitle: () => _i18n.i18n.translate('controls.controlGroup.management.selectionSettings', {
        defaultMessage: 'Selections'
      }),
      validateSelections: {
        getValidateSelectionsTitle: () => _i18n.i18n.translate('controls.controlGroup.management.validate.title', {
          defaultMessage: 'Validate user selections'
        }),
        getValidateSelectionsTooltip: () => _i18n.i18n.translate('controls.controlGroup.management.validate.tooltip', {
          defaultMessage: 'Highlight control selections that result in no data.'
        })
      },
      controlChaining: {
        getHierarchyTitle: () => _i18n.i18n.translate('controls.controlGroup.management.hierarchy.title', {
          defaultMessage: 'Chain controls'
        }),
        getHierarchyTooltip: () => _i18n.i18n.translate('controls.controlGroup.management.hierarchy.tooltip', {
          defaultMessage: 'Selections in one control narrow down available options in the next. Controls are chained from left to right.'
        })
      },
      showApplySelections: {
        getShowApplySelectionsTitle: () => _i18n.i18n.translate('controls.controlGroup.management.showApplySelections.title', {
          defaultMessage: 'Apply selections automatically'
        }),
        getShowApplySelectionsTooltip: () => _i18n.i18n.translate('controls.controlGroup.management.showApplySelections.tooltip', {
          defaultMessage: 'If disabled, control selections will only be applied after clicking apply.'
        })
      }
    },
    filteringSettings: {
      getFilteringSettingsTitle: () => _i18n.i18n.translate('controls.controlGroup.management.filteringSettings', {
        defaultMessage: 'Filtering'
      }),
      getUseGlobalFiltersTitle: () => _i18n.i18n.translate('controls.controlGroup.management.filtering.useGlobalFilters', {
        defaultMessage: 'Apply global filters to controls'
      }),
      getUseGlobalTimeRangeTitle: () => _i18n.i18n.translate('controls.controlGroup.management.filtering.useGlobalTimeRange', {
        defaultMessage: 'Apply global time range to controls'
      })
    }
  }
};