"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlClone = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * A simplified clone version of the control which is dragged. This version only shows
 * the title, because individual controls can be any size, and dragging a wide item
 * can be quite cumbersome.
 */
const ControlClone = ({
  labelPosition,
  controlApi
}) => {
  const [width, panelTitle, defaultPanelTitle] = (0, _presentationPublishing.useBatchedPublishingSubjects)(controlApi ? controlApi.width : new _rxjs.BehaviorSubject(_common.DEFAULT_CONTROL_GROW), controlApi !== null && controlApi !== void 0 && controlApi.panelTitle ? controlApi.panelTitle : new _rxjs.BehaviorSubject(undefined), controlApi !== null && controlApi !== void 0 && controlApi.defaultPanelTitle ? controlApi.defaultPanelTitle : new _rxjs.BehaviorSubject(''));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _classnames.default)('controlFrameCloneWrapper', {
      'controlFrameCloneWrapper--small': width === 'small',
      'controlFrameCloneWrapper--medium': width === 'medium',
      'controlFrameCloneWrapper--large': width === 'large',
      'controlFrameCloneWrapper--twoLine': labelPosition === 'twoLine'
    })
  }, labelPosition === 'twoLine' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    className: 'controlFrame__draggable'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grabHorizontal",
    className: "controlFrame__dragHandle"
  })), labelPosition === 'oneLine' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("label", {
    className: "controlFrameCloneWrapper__label"
  }, panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle)) : undefined));
};
exports.ControlClone = ControlClone;