"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditControlAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _ = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class EditControlAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _.ACTION_EDIT_CONTROL);
    (0, _defineProperty2.default)(this, "id", _.ACTION_EDIT_CONTROL);
    (0, _defineProperty2.default)(this, "order", 2);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: this.getDisplayName(context)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `control-action-${context.embeddable.uuid}-edit`,
        "aria-label": this.getDisplayName(context),
        iconType: this.getIconType(context),
        onClick: () => this.execute(context),
        color: "text"
      }));
    });
  }
  getDisplayName({
    embeddable
  }) {
    return _i18n.i18n.translate('controls.controlGroup.floatingActions.editTitle', {
      defaultMessage: 'Edit'
    });
  }
  getIconType({
    embeddable
  }) {
    return 'pencil';
  }
  async isCompatible({
    embeddable
  }) {
    const {
      isCompatible
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./edit_control_action_compatibility_check')));
    return isCompatible(embeddable);
  }
  async execute({
    embeddable
  }) {
    const {
      compatibilityCheck
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./edit_control_action_compatibility_check')));
    if (!compatibilityCheck(embeddable)) throw new _public.IncompatibleActionError();
    await embeddable.onEdit();
  }
}
exports.EditControlAction = EditControlAction;