"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compatibilityCheck = void 0;
exports.isCompatible = isCompatible;
var _public = require("@kbn/embeddable-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const compatibilityCheck = api => Boolean((0, _presentationPublishing.apiHasType)(api) && (0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api.parentApi) && (0, _presentationPublishing.apiIsOfType)(api.parentApi, _common.CONTROL_GROUP_TYPE) && (0, _presentationContainers.apiIsPresentationContainer)(api.parentApi));
exports.compatibilityCheck = compatibilityCheck;
function isCompatible(api) {
  return compatibilityCheck(api) && (0, _presentationPublishing.getInheritedViewMode)(api.parentApi) === _public.ViewMode.EDIT;
}