"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FavoritesService = void 0;
var _server = require("@kbn/core/server");
var _favorites_saved_object = require("./favorites_saved_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class FavoritesService {
  constructor(type, userId, deps) {
    this.type = type;
    this.userId = userId;
    this.deps = deps;
    if (!this.userId || !this.type) {
      // This should never happen, but just in case let's do a runtime check
      throw new Error('userId and object type are required to use a favorite service');
    }
  }
  async getFavorites() {
    var _favoritesSavedObject, _favoritesSavedObject2;
    const favoritesSavedObject = await this.getFavoritesSavedObject();
    const favoriteIds = (_favoritesSavedObject = favoritesSavedObject === null || favoritesSavedObject === void 0 ? void 0 : (_favoritesSavedObject2 = favoritesSavedObject.attributes) === null || _favoritesSavedObject2 === void 0 ? void 0 : _favoritesSavedObject2.favoriteIds) !== null && _favoritesSavedObject !== void 0 ? _favoritesSavedObject : [];
    return {
      favoriteIds
    };
  }
  async addFavorite({
    id
  }) {
    let favoritesSavedObject = await this.getFavoritesSavedObject();
    if (!favoritesSavedObject) {
      favoritesSavedObject = await this.deps.savedObjectClient.create(_favorites_saved_object.favoritesSavedObjectType.name, {
        userId: this.userId,
        type: this.type,
        favoriteIds: [id]
      }, {
        id: this.getFavoriteSavedObjectId()
      });
      return {
        favoriteIds: favoritesSavedObject.attributes.favoriteIds
      };
    } else {
      var _favoritesSavedObject3;
      const newFavoriteIds = [...((_favoritesSavedObject3 = favoritesSavedObject.attributes.favoriteIds) !== null && _favoritesSavedObject3 !== void 0 ? _favoritesSavedObject3 : []).filter(favoriteId => favoriteId !== id), id];
      await this.deps.savedObjectClient.update(_favorites_saved_object.favoritesSavedObjectType.name, favoritesSavedObject.id, {
        favoriteIds: newFavoriteIds
      }, {
        version: favoritesSavedObject.version
      });
      return {
        favoriteIds: newFavoriteIds
      };
    }
  }
  async removeFavorite({
    id
  }) {
    var _favoritesSavedObject4;
    const favoritesSavedObject = await this.getFavoritesSavedObject();
    if (!favoritesSavedObject) {
      return {
        favoriteIds: []
      };
    }
    const newFavoriteIds = ((_favoritesSavedObject4 = favoritesSavedObject.attributes.favoriteIds) !== null && _favoritesSavedObject4 !== void 0 ? _favoritesSavedObject4 : []).filter(favoriteId => favoriteId !== id);
    await this.deps.savedObjectClient.update(_favorites_saved_object.favoritesSavedObjectType.name, favoritesSavedObject.id, {
      favoriteIds: newFavoriteIds
    }, {
      version: favoritesSavedObject.version
    });
    return {
      favoriteIds: newFavoriteIds
    };
  }
  async getFavoritesSavedObject() {
    try {
      const favoritesSavedObject = await this.deps.savedObjectClient.get(_favorites_saved_object.favoritesSavedObjectType.name, this.getFavoriteSavedObjectId());
      return favoritesSavedObject;
    } catch (e) {
      if (_server.SavedObjectsErrorHelpers.isNotFoundError(e)) {
        return null;
      }
      throw e;
    }
  }
  getFavoriteSavedObjectId() {
    return `${this.type}:${this.userId}`;
  }
}
exports.FavoritesService = FavoritesService;