"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerContentInsights = void 0;
var _configSchema = require("@kbn/config-schema");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Configuration for the usage counter
 */

/*
 * Registers the content insights routes
 */
const registerContentInsights = ({
  usageCollection,
  http,
  getStartServices
}, config) => {
  var _config$retentionPeri;
  const retentionPeriodDays = (_config$retentionPeri = config.retentionPeriodDays) !== null && _config$retentionPeri !== void 0 ? _config$retentionPeri : 90;
  const counter = usageCollection.createUsageCounter(config.domainId, {
    retentionPeriodDays
  });
  const router = http.createRouter();
  const validate = {
    params: _configSchema.schema.object({
      id: _configSchema.schema.string(),
      eventType: _configSchema.schema.literal('viewed')
    })
  };
  router.post({
    path: `/internal/content_management/insights/${config.domainId}/{id}/{eventType}`,
    validate,
    options: {
      tags: config.routeTags
    }
  }, async (context, req, res) => {
    const {
      id,
      eventType
    } = req.params;
    counter.incrementCounter({
      counterName: id,
      counterType: eventType,
      namespace: (await context.core).savedObjects.client.getCurrentNamespace()
    });
    return res.ok();
  });
  router.get({
    path: `/internal/content_management/insights/${config.domainId}/{id}/{eventType}/stats`,
    validate,
    options: {
      tags: config.routeTags
    }
  }, async (context, req, res) => {
    var _result$counters$0$co, _result$counters$, _result$counters$0$re, _result$counters$2;
    const {
      id,
      eventType
    } = req.params;
    const {
      usageCollection: {
        search
      }
    } = await getStartServices();
    const startOfDay = _moment.default.utc().startOf('day');
    const from = startOfDay.clone().subtract(retentionPeriodDays, 'days');
    const result = await search({
      filters: {
        domainId: config.domainId,
        counterName: id,
        counterType: eventType,
        namespace: (await context.core).savedObjects.client.getCurrentNamespace(),
        from: from.toISOString()
      }
    });
    const response = {
      result: {
        from: from.toISOString(),
        count: (_result$counters$0$co = (_result$counters$ = result.counters[0]) === null || _result$counters$ === void 0 ? void 0 : _result$counters$.count) !== null && _result$counters$0$co !== void 0 ? _result$counters$0$co : 0,
        daily: ((_result$counters$0$re = (_result$counters$2 = result.counters[0]) === null || _result$counters$2 === void 0 ? void 0 : _result$counters$2.records) !== null && _result$counters$0$re !== void 0 ? _result$counters$0$re : []).map(record => ({
          date: record.updatedAt,
          count: record.count
        }))
      }
    };
    return res.ok({
      body: response
    });
  });
};
exports.registerContentInsights = registerContentInsights;