"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEsConfigRoute = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerEsConfigRoute = ({
  router,
  services
}) => {
  router.get({
    path: '/api/console/es_config',
    validate: false
  }, async (ctx, req, res) => {
    const cloudUrl = services.esLegacyConfigService.getCloudUrl();
    if (cloudUrl) {
      const body = {
        host: cloudUrl
      };
      return res.ok({
        body
      });
    }
    const {
      hosts: [host]
    } = await services.esLegacyConfigService.readConfig();
    const body = {
      host
    };
    return res.ok({
      body
    });
  });
};
exports.registerEsConfigRoute = registerEsConfigRoute;