"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonacoEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _codeEditor = require("@kbn/code-editor");
var _monaco = require("@kbn/monaco");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
var _components = require("./components");
var _contexts = require("../../contexts");
var _hooks2 = require("./hooks");
var _monaco_editor_actions_provider = require("./monaco_editor_actions_provider");
var _monaco_editor_suggestion_provider = require("./monaco_editor_suggestion_provider");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MonacoEditor = ({
  localStorageValue,
  value,
  setValue
}) => {
  const context = (0, _contexts.useServicesContext)();
  const {
    services: {
      notifications,
      settings: settingsService,
      autocompleteInfo
    },
    docLinkVersion,
    config: {
      isDevMode
    }
  } = context;
  const {
    toasts
  } = notifications;
  const {
    settings,
    restoreRequestFromHistory: requestToRestoreFromHistory,
    fileToImport
  } = (0, _contexts.useEditorReadContext)();
  const [editorInstance, setEditorInstace] = (0, _react.useState)();
  const divRef = (0, _react.useRef)(null);
  const {
    setupResizeChecker,
    destroyResizeChecker
  } = (0, _hooks2.useResizeCheckerUtils)();
  const {
    registerKeyboardCommands,
    unregisterKeyboardCommands
  } = (0, _hooks2.useKeyboardCommandsUtils)();
  const dispatch = (0, _contexts.useRequestActionContext)();
  const editorDispatch = (0, _contexts.useEditorActionContext)();
  const actionsProvider = (0, _react.useRef)(null);
  const [editorActionsCss, setEditorActionsCss] = (0, _react.useState)({});
  const setInputEditor = (0, _hooks.useSetInputEditor)();
  const getRequestsCallback = (0, _react.useCallback)(async () => {
    var _actionsProvider$curr;
    const requests = await ((_actionsProvider$curr = actionsProvider.current) === null || _actionsProvider$curr === void 0 ? void 0 : _actionsProvider$curr.getRequests());
    return requests !== null && requests !== void 0 ? requests : [];
  }, []);
  const getDocumenationLink = (0, _react.useCallback)(async () => {
    return actionsProvider.current.getDocumentationLink(docLinkVersion);
  }, [docLinkVersion]);
  const autoIndentCallback = (0, _react.useCallback)(async () => {
    return actionsProvider.current.autoIndent();
  }, []);
  const sendRequestsCallback = (0, _react.useCallback)(async () => {
    var _actionsProvider$curr2;
    await ((_actionsProvider$curr2 = actionsProvider.current) === null || _actionsProvider$curr2 === void 0 ? void 0 : _actionsProvider$curr2.sendRequests(dispatch, context));
  }, [dispatch, context]);
  const editorDidMountCallback = (0, _react.useCallback)(editor => {
    const provider = new _monaco_editor_actions_provider.MonacoEditorActionsProvider(editor, setEditorActionsCss, isDevMode);
    setInputEditor(provider);
    actionsProvider.current = provider;
    setupResizeChecker(divRef.current, editor);
    setEditorInstace(editor);
  }, [setupResizeChecker, setInputEditor, setEditorInstace, isDevMode]);
  (0, _react.useEffect)(() => {
    if (settings.isKeyboardShortcutsEnabled && editorInstance) {
      registerKeyboardCommands({
        editor: editorInstance,
        sendRequest: sendRequestsCallback,
        autoIndent: async () => {
          var _actionsProvider$curr3;
          return await ((_actionsProvider$curr3 = actionsProvider.current) === null || _actionsProvider$curr3 === void 0 ? void 0 : _actionsProvider$curr3.autoIndent());
        },
        getDocumentationLink: getDocumenationLink,
        moveToPreviousRequestEdge: async () => {
          var _actionsProvider$curr4;
          return await ((_actionsProvider$curr4 = actionsProvider.current) === null || _actionsProvider$curr4 === void 0 ? void 0 : _actionsProvider$curr4.moveToPreviousRequestEdge());
        },
        moveToNextRequestEdge: async () => {
          var _actionsProvider$curr5;
          return await ((_actionsProvider$curr5 = actionsProvider.current) === null || _actionsProvider$curr5 === void 0 ? void 0 : _actionsProvider$curr5.moveToNextRequestEdge());
        }
      });
    } else {
      unregisterKeyboardCommands();
    }
  }, [editorInstance, getDocumenationLink, sendRequestsCallback, registerKeyboardCommands, unregisterKeyboardCommands, settings.isKeyboardShortcutsEnabled]);
  const editorWillUnmountCallback = (0, _react.useCallback)(() => {
    destroyResizeChecker();
    unregisterKeyboardCommands();
  }, [destroyResizeChecker, unregisterKeyboardCommands]);
  const suggestionProvider = (0, _react.useMemo)(() => {
    return (0, _monaco_editor_suggestion_provider.getSuggestionProvider)(actionsProvider);
  }, []);
  (0, _hooks2.useSetInitialValue)({
    localStorageValue,
    setValue,
    toasts
  });
  (0, _hooks2.useSetupAutocompletePolling)({
    autocompleteInfo,
    settingsService
  });
  (0, _hooks2.useSetupAutosave)({
    value
  });

  // Restore the request from history if there is one
  const updateEditor = (0, _react.useCallback)(async () => {
    if (requestToRestoreFromHistory) {
      var _actionsProvider$curr6;
      editorDispatch({
        type: 'clearRequestToRestore'
      });
      await ((_actionsProvider$curr6 = actionsProvider.current) === null || _actionsProvider$curr6 === void 0 ? void 0 : _actionsProvider$curr6.appendRequestToEditor(requestToRestoreFromHistory, dispatch, context));
    }

    // Import a request file if one is provided
    if (fileToImport) {
      var _actionsProvider$curr7;
      editorDispatch({
        type: 'setFileToImport',
        payload: null
      });
      await ((_actionsProvider$curr7 = actionsProvider.current) === null || _actionsProvider$curr7 === void 0 ? void 0 : _actionsProvider$curr7.importRequestsToEditor(fileToImport));
    }
  }, [fileToImport, requestToRestoreFromHistory, dispatch, context, editorDispatch]);
  (0, _react.useEffect)(() => {
    updateEditor();
  }, [updateEditor]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 100%;
        height: 100%;
      `,
    ref: divRef,
    "data-test-subj": "consoleMonacoEditorContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "conApp__editorActions",
    id: "ConAppEditorActions",
    gutterSize: "xs",
    responsive: false,
    style: editorActionsCss,
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('console.monaco.sendRequestButtonTooltipContent', {
      defaultMessage: 'Click to send request'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "playFilled",
    onClick: sendRequestsCallback,
    "data-test-subj": "sendRequestButton",
    "aria-label": _i18n.i18n.translate('console.monaco.sendRequestButtonTooltipAriaLabel', {
      defaultMessage: 'Click to send request'
    }),
    iconSize: 's'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.ContextMenu, {
    getRequests: getRequestsCallback,
    getDocumentation: getDocumenationLink,
    autoIndent: autoIndentCallback,
    notifications: notifications
  }))), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    dataTestSubj: 'consoleMonacoEditor',
    languageId: _monaco.CONSOLE_LANG_ID,
    value: value,
    onChange: setValue,
    fullWidth: true,
    accessibilityOverlayEnabled: settings.isAccessibilityOverlayEnabled,
    editorDidMount: editorDidMountCallback,
    editorWillUnmount: editorWillUnmountCallback,
    options: {
      fontSize: settings.fontSize,
      wordWrap: settings.wrapMode === true ? 'on' : 'off',
      theme: _monaco.CONSOLE_THEME_ID,
      // Make the quick-fix window be fixed to the window rather than clipped by
      // the parent content set with overflow: hidden/auto
      fixedOverflowWidgets: true
    },
    suggestionProvider: suggestionProvider,
    enableFindAction: true
  }));
};
exports.MonacoEditor = MonacoEditor;