"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleTourStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ConsoleTourStep = ({
  tourStepProps,
  children
}) => {
  const {
    step,
    isStepOpen,
    stepsTotal,
    title,
    content,
    onFinish,
    footerAction,
    dataTestSubj,
    anchorPosition,
    maxWidth,
    css
  } = tourStepProps;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    step: step,
    stepsTotal: stepsTotal,
    isStepOpen: isStepOpen,
    title: title,
    content: content,
    onFinish: onFinish,
    footerAction: footerAction,
    "data-test-subj": dataTestSubj,
    anchorPosition: anchorPosition,
    maxWidth: maxWidth,
    css: css
  }, children);
};
exports.ConsoleTourStep = ConsoleTourStep;