"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecordOfType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typeDetect = _interopRequireDefault(require("type-detect"));
var _errors = require("../errors");
var _internals = require("../internals");
var _type = require("./type");
var _oas_meta_fields = require("../oas_meta_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class RecordOfType extends _type.Type {
  constructor(keyType, valueType, options = {}) {
    const schema = _internals.internals.record().entries(keyType.getSchema(), valueType.getSchema()).meta({
      [_oas_meta_fields.META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES]: () => valueType.getSchema()
    });
    super(schema, options);
    (0, _defineProperty2.default)(this, "keyType", void 0);
    (0, _defineProperty2.default)(this, "valueType", void 0);
    (0, _defineProperty2.default)(this, "options", void 0);
    this.keyType = keyType;
    this.valueType = valueType;
    this.options = options;
  }
  extendsDeep(options) {
    return new RecordOfType(this.keyType.extendsDeep(options), this.valueType.extendsDeep(options), this.options);
  }
  handleError(type, {
    entryKey,
    reason,
    value
  }, path) {
    switch (type) {
      case 'any.required':
      case 'record.base':
        return `expected value of type [object] but got [${(0, _typeDetect.default)(value)}]`;
      case 'record.parse':
        return `could not parse record value from json input`;
      case 'record.key':
      case 'record.value':
        const childPathWithIndex = path.slice();
        childPathWithIndex.splice(path.length, 0,
        // If `key` validation failed, let's stress that to make error more obvious.
        type === 'record.key' ? `key("${entryKey}")` : entryKey.toString(),
        // Error could have happened deep inside value/key schema and error message should
        // include full path.
        ...(reason instanceof _errors.SchemaTypeError ? reason.path : []));
        return reason instanceof _errors.SchemaTypesError ? new _errors.SchemaTypesError(reason, childPathWithIndex, reason.errors) : new _errors.SchemaTypeError(reason, childPathWithIndex);
    }
  }
}
exports.RecordOfType = RecordOfType;