"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statusQueryParamsSchema = exports.getCspStatus = exports.defineGetCspStatusRoute = exports.calculateIntegrationStatus = exports.INDEX_TIMEOUT_IN_MINUTES_CNVM = exports.INDEX_TIMEOUT_IN_MINUTES = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _moment = _interopRequireDefault(require("moment"));
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../common/constants");
var _fleet_util = require("../../lib/fleet_util");
var _check_index_status = require("../../lib/check_index_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_TIMEOUT_IN_MINUTES = exports.INDEX_TIMEOUT_IN_MINUTES = 10;
const INDEX_TIMEOUT_IN_MINUTES_CNVM = exports.INDEX_TIMEOUT_IN_MINUTES_CNVM = 240;
const calculateDiffFromNowInMinutes = date => (0, _moment.default)().diff((0, _moment.default)(date), 'minutes');
const getHealthyAgents = async (soClient, installedCspPackagePolicies, agentPolicyService, agentService, logger) => {
  // Get agent policies of package policies (from installed package policies)
  const agentPolicies = await (0, _fleet_util.getCspAgentPolicies)(soClient, installedCspPackagePolicies, agentPolicyService);

  // Get agents statuses of the following agent policies
  const agentStatusesByAgentPolicyId = await (0, _fleet_util.getAgentStatusesByAgentPolicies)(agentService, agentPolicies, logger);
  return Object.values(agentStatusesByAgentPolicyId).reduce((sum, status) => sum + status.online + status.updating, 0);
};
const calculateIntegrationStatus = (integration, indicesStatus, installation, healthyAgents, timeSinceInstallationInMinutes, installedPolicyTemplates) => {
  // We check privileges only for the relevant indices for our pages to appear
  const postureTypeCheck = _constants.POSTURE_TYPES[integration];
  if (indicesStatus.latest === 'unprivileged' || indicesStatus.score === 'unprivileged') return 'unprivileged';
  if (!installation) return 'not-installed';
  if (indicesStatus.latest === 'not-empty') return 'indexed';
  if (indicesStatus.stream === 'not-empty' && indicesStatus.latest === 'empty') return 'indexing';
  if (!installedPolicyTemplates.includes(postureTypeCheck)) return 'not-installed';
  if (healthyAgents === 0) return 'not-deployed';
  if (indicesStatus.latest === 'empty' && indicesStatus.stream === 'empty' && timeSinceInstallationInMinutes < (postureTypeCheck !== _constants.VULN_MGMT_POLICY_TEMPLATE ? INDEX_TIMEOUT_IN_MINUTES : INDEX_TIMEOUT_IN_MINUTES_CNVM)) return 'waiting_for_results';
  return 'index-timeout';
};
exports.calculateIntegrationStatus = calculateIntegrationStatus;
const assertResponse = (resp, logger) => {
  if ((resp.cspm.status || resp.kspm.status) === 'unprivileged' && !resp.indicesDetails.some(idxDetails => idxDetails.status === 'unprivileged')) {
    logger.warn('Returned status in `unprivileged` but response is missing the unprivileged index');
  }
};
const checkIndexHasFindings = async (esClient, index, retentionPolicy, logger) => {
  try {
    const response = await esClient.search({
      index,
      size: 0,
      // We only need to know if there are any hits, so we don't need to retrieve documents
      query: {
        bool: {
          filter: [{
            range: {
              '@timestamp': {
                gte: `now-${retentionPolicy}`,
                lte: 'now'
              }
            }
          }]
        }
      },
      ignore_unavailable: true
    });

    // Check the number of hits
    const totalHits = typeof response.hits.total === 'object' ? response.hits.total.value : response.hits.total;
    return !!totalHits;
  } catch (err) {
    logger.error(`Error checking if index ${index} has findings`);
    logger.error(err);
  }
};
const getCspStatus = async ({
  logger,
  esClient,
  soClient,
  packageService,
  packagePolicyService,
  agentPolicyService,
  agentService,
  isPluginInitialized
}) => {
  const [hasMisconfigurationsFindings, hasVulnerabilitiesFindings, findingsLatestIndexStatus, findingsIndexStatus, scoreIndexStatus, findingsLatestIndexStatusCspm, findingsIndexStatusCspm, scoreIndexStatusCspm, findingsLatestIndexStatusKspm, findingsIndexStatusKspm, scoreIndexStatusKspm, vulnerabilitiesLatestIndexStatus, vulnerabilitiesIndexStatus, installation, latestCspPackage, installedPackagePoliciesKspm, installedPackagePoliciesCspm, installedPackagePoliciesVulnMgmt, installedPolicyTemplates] = await Promise.all([checkIndexHasFindings(esClient, _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_INDEX_PATTERN, _cloudSecurityPostureCommon.CDR_3RD_PARTY_RETENTION_POLICY, logger), checkIndexHasFindings(esClient, _cloudSecurityPostureCommon.CDR_VULNERABILITIES_INDEX_PATTERN, _cloudSecurityPostureCommon.CDR_3RD_PARTY_RETENTION_POLICY, logger), (0, _check_index_status.checkIndexStatus)(esClient, _constants.LATEST_FINDINGS_INDEX_DEFAULT_NS, logger, {
    postureType: _constants.POSTURE_TYPE_ALL,
    retentionTime: _cloudSecurityPostureCommon.LATEST_VULNERABILITIES_RETENTION_POLICY
  }), (0, _check_index_status.checkIndexStatus)(esClient, _constants.FINDINGS_INDEX_PATTERN, logger, {
    postureType: _constants.POSTURE_TYPE_ALL,
    retentionTime: _cloudSecurityPostureCommon.LATEST_VULNERABILITIES_RETENTION_POLICY
  }), (0, _check_index_status.checkIndexStatus)(esClient, _constants.BENCHMARK_SCORE_INDEX_DEFAULT_NS, logger, {
    postureType: _constants.POSTURE_TYPE_ALL,
    retentionTime: _cloudSecurityPostureCommon.LATEST_VULNERABILITIES_RETENTION_POLICY
  }), (0, _check_index_status.checkIndexStatus)(esClient, _constants.LATEST_FINDINGS_INDEX_DEFAULT_NS, logger, {
    postureType: _cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE,
    retentionTime: _cloudSecurityPostureCommon.LATEST_FINDINGS_RETENTION_POLICY
  }), (0, _check_index_status.checkIndexStatus)(esClient, _constants.FINDINGS_INDEX_PATTERN, logger, {
    postureType: _cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE,
    retentionTime: _cloudSecurityPostureCommon.LATEST_FINDINGS_RETENTION_POLICY
  }), (0, _check_index_status.checkIndexStatus)(esClient, _constants.BENCHMARK_SCORE_INDEX_DEFAULT_NS, logger, {
    postureType: _cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE,
    retentionTime: _cloudSecurityPostureCommon.LATEST_FINDINGS_RETENTION_POLICY
  }), (0, _check_index_status.checkIndexStatus)(esClient, _constants.LATEST_FINDINGS_INDEX_DEFAULT_NS, logger, {
    postureType: _cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE,
    retentionTime: _cloudSecurityPostureCommon.LATEST_FINDINGS_RETENTION_POLICY
  }), (0, _check_index_status.checkIndexStatus)(esClient, _constants.FINDINGS_INDEX_PATTERN, logger, {
    postureType: _cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE,
    retentionTime: _cloudSecurityPostureCommon.LATEST_FINDINGS_RETENTION_POLICY
  }), (0, _check_index_status.checkIndexStatus)(esClient, _constants.BENCHMARK_SCORE_INDEX_DEFAULT_NS, logger, {
    postureType: _cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE,
    retentionTime: _cloudSecurityPostureCommon.LATEST_FINDINGS_RETENTION_POLICY
  }), (0, _check_index_status.checkIndexStatus)(esClient, _cloudSecurityPostureCommon.CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN, logger, {
    postureType: _constants.VULN_MGMT_POLICY_TEMPLATE,
    retentionTime: _cloudSecurityPostureCommon.LATEST_VULNERABILITIES_RETENTION_POLICY
  }), (0, _check_index_status.checkIndexStatus)(esClient, _constants.VULNERABILITIES_INDEX_PATTERN, logger, {
    postureType: _constants.VULN_MGMT_POLICY_TEMPLATE,
    retentionTime: _cloudSecurityPostureCommon.LATEST_VULNERABILITIES_RETENTION_POLICY
  }), packageService.asInternalUser.getInstallation(_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME), packageService.asInternalUser.fetchFindLatestPackage(_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME), (0, _fleet_util.getCspPackagePolicies)(soClient, packagePolicyService, _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME, {
    per_page: 10000
  }, _cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE), (0, _fleet_util.getCspPackagePolicies)(soClient, packagePolicyService, _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME, {
    per_page: 10000
  }, _cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE), (0, _fleet_util.getCspPackagePolicies)(soClient, packagePolicyService, _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME, {
    per_page: 10000
  }, _constants.VULN_MGMT_POLICY_TEMPLATE), (0, _fleet_util.getInstalledPolicyTemplates)(packagePolicyService, soClient)]);
  const healthyAgentsKspm = await getHealthyAgents(soClient, installedPackagePoliciesKspm.items, agentPolicyService, agentService, logger);
  const healthyAgentsCspm = await getHealthyAgents(soClient, installedPackagePoliciesCspm.items, agentPolicyService, agentService, logger);
  const healthyAgentsVulMgmt = await getHealthyAgents(soClient, installedPackagePoliciesVulnMgmt.items, agentPolicyService, agentService, logger);
  const installedPackagePoliciesTotalKspm = installedPackagePoliciesKspm.total;
  const installedPackagePoliciesTotalCspm = installedPackagePoliciesCspm.total;
  const installedPackagePoliciesTotalVulnMgmt = installedPackagePoliciesVulnMgmt.total;
  const latestCspPackageVersion = latestCspPackage.version;
  const MIN_DATE = 0;
  const indicesDetails = [{
    index: _constants.LATEST_FINDINGS_INDEX_DEFAULT_NS,
    status: findingsLatestIndexStatus
  }, {
    index: _constants.FINDINGS_INDEX_PATTERN,
    status: findingsIndexStatus
  }, {
    index: _constants.BENCHMARK_SCORE_INDEX_DEFAULT_NS,
    status: scoreIndexStatus
  }, {
    index: _cloudSecurityPostureCommon.CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN,
    status: vulnerabilitiesLatestIndexStatus
  }];
  const statusCspm = calculateIntegrationStatus(_cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE, {
    latest: findingsLatestIndexStatusCspm,
    stream: findingsIndexStatusCspm,
    score: scoreIndexStatusCspm
  }, installation, healthyAgentsCspm, calculateDiffFromNowInMinutes((installation === null || installation === void 0 ? void 0 : installation.install_started_at) || MIN_DATE), installedPolicyTemplates);
  const statusKspm = calculateIntegrationStatus(_cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE, {
    latest: findingsLatestIndexStatusKspm,
    stream: findingsIndexStatusKspm,
    score: scoreIndexStatusKspm
  }, installation, healthyAgentsKspm, calculateDiffFromNowInMinutes((installation === null || installation === void 0 ? void 0 : installation.install_started_at) || MIN_DATE), installedPolicyTemplates);
  const statusVulnMgmt = calculateIntegrationStatus(_constants.VULN_MGMT_POLICY_TEMPLATE, {
    latest: vulnerabilitiesLatestIndexStatus,
    stream: vulnerabilitiesIndexStatus,
    score: scoreIndexStatus
  }, installation, healthyAgentsVulMgmt, calculateDiffFromNowInMinutes((installation === null || installation === void 0 ? void 0 : installation.install_started_at) || MIN_DATE), installedPolicyTemplates);
  const statusResponseInfo = getStatusResponse({
    statusCspm,
    statusKspm,
    statusVulnMgmt,
    healthyAgentsCspm,
    healthyAgentsKspm,
    healthyAgentsVulMgmt,
    installedPackagePoliciesTotalKspm,
    installedPackagePoliciesTotalCspm,
    installedPackagePoliciesTotalVulnMgmt,
    indicesDetails,
    latestCspPackageVersion,
    isPluginInitialized: isPluginInitialized()
  });
  const response = {
    ...statusResponseInfo,
    installedPackageVersion: installation === null || installation === void 0 ? void 0 : installation.install_version,
    hasMisconfigurationsFindings,
    hasVulnerabilitiesFindings
  };
  assertResponse(response, logger);
  return response;
};
exports.getCspStatus = getCspStatus;
const statusQueryParamsSchema = exports.statusQueryParamsSchema = _configSchema.schema.object({
  /**
   * CSP Plugin initialization includes creating indices/transforms/tasks.
   * Prior to this initialization, the plugin is not ready to index findings.
   */
  check: _configSchema.schema.oneOf([_configSchema.schema.literal('all'), _configSchema.schema.literal('init')], {
    defaultValue: 'all'
  })
});
const defineGetCspStatusRoute = router => router.versioned.get({
  access: 'internal',
  path: _cloudSecurityPostureCommon.STATUS_ROUTE_PATH,
  options: {
    tags: ['access:cloud-security-posture-read']
  }
}).addVersion({
  version: '1',
  validate: {
    request: {
      query: statusQueryParamsSchema
    }
  }
}, async (context, request, response) => {
  const cspContext = await context.csp;
  try {
    if (request.query.check === 'init') {
      return response.ok({
        body: {
          isPluginInitialized: cspContext.isPluginInitialized()
        }
      });
    }
    const status = await getCspStatus({
      ...cspContext,
      esClient: cspContext.esClient.asCurrentUser
    });
    return response.ok({
      body: status
    });
  } catch (err) {
    cspContext.logger.error(`Error getting csp status`);
    cspContext.logger.error(err);
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineGetCspStatusRoute = defineGetCspStatusRoute;
const getStatusResponse = statusResponseInfo => {
  const {
    statusCspm,
    statusKspm,
    statusVulnMgmt,
    healthyAgentsCspm,
    healthyAgentsKspm,
    healthyAgentsVulMgmt,
    installedPackagePoliciesTotalKspm,
    installedPackagePoliciesTotalCspm,
    installedPackagePoliciesTotalVulnMgmt,
    indicesDetails,
    latestCspPackageVersion,
    isPluginInitialized
  } = statusResponseInfo;
  return {
    [_cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE]: {
      status: statusCspm,
      healthyAgents: healthyAgentsCspm,
      installedPackagePolicies: installedPackagePoliciesTotalCspm
    },
    [_cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE]: {
      status: statusKspm,
      healthyAgents: healthyAgentsKspm,
      installedPackagePolicies: installedPackagePoliciesTotalKspm
    },
    [_constants.VULN_MGMT_POLICY_TEMPLATE]: {
      status: statusVulnMgmt,
      healthyAgents: healthyAgentsVulMgmt,
      installedPackagePolicies: installedPackagePoliciesTotalVulnMgmt
    },
    indicesDetails,
    isPluginInitialized,
    latestPackageVersion: latestCspPackageVersion
  };
};