"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineGraphRoute = void 0;
var _latest = require("@kbn/cloud-security-posture-common/schema/graph/latest");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../common/constants");
var _v = require("./v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defineGraphRoute = router => router.versioned.post({
  access: 'internal',
  enableQueryVersion: true,
  path: _constants.GRAPH_ROUTE_PATH,
  options: {
    tags: ['access:cloud-security-posture-read']
  }
}).addVersion({
  version: '1',
  validate: {
    request: {
      body: _latest.graphRequestSchema
    },
    response: {
      200: {
        body: _latest.graphResponseSchema
      }
    }
  }
}, async (context, request, response) => {
  var _await$cspContext$spa, _cspContext$spaces, _cspContext$spaces$sp;
  const {
    actorIds,
    eventIds,
    start,
    end
  } = request.body.query;
  const cspContext = await context.csp;
  const spaceId = (_await$cspContext$spa = await ((_cspContext$spaces = cspContext.spaces) === null || _cspContext$spaces === void 0 ? void 0 : (_cspContext$spaces$sp = _cspContext$spaces.spacesService) === null || _cspContext$spaces$sp === void 0 ? void 0 : _cspContext$spaces$sp.getActiveSpace(request))) === null || _await$cspContext$spa === void 0 ? void 0 : _await$cspContext$spa.id;
  try {
    const {
      nodes,
      edges
    } = await (0, _v.getGraph)({
      logger: cspContext.logger,
      esClient: cspContext.esClient
    }, {
      actorIds,
      eventIds,
      spaceId,
      start,
      end
    });
    return response.ok({
      body: {
        nodes,
        edges
      }
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch graph ${err}`);
    cspContext.logger.error(err);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineGraphRoute = defineGraphRoute;