"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatestVulnerabilitiesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _get_vendor_name = require("../../common/utils/get_vendor_name");
var _cloud_security_data_table = require("../../components/cloud_security_data_table");
var _use_latest_vulnerabilities_table = require("./hooks/use_latest_vulnerabilities_table");
var _test_subjects = require("./test_subjects");
var _constants = require("./constants");
var _vulnerability_finding_flyout = require("./vulnerabilities_finding_flyout/vulnerability_finding_flyout");
var _error_callout = require("../configurations/layout/error_callout");
var _create_detection_rule_from_vulnerability = require("./utils/create_detection_rule_from_vulnerability");
var _vulnerabilities_table_field_labels = require("./vulnerabilities_table_field_labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type Guard for checking if the given source is a CspVulnerabilityFinding
 */
const isCspVulnerabilityFinding = source => {
  var _source$vulnerability;
  return (source === null || source === void 0 ? void 0 : (_source$vulnerability = source.vulnerability) === null || _source$vulnerability === void 0 ? void 0 : _source$vulnerability.id) !== undefined;
};
const getCspVulnerabilityFinding = source => {
  return isCspVulnerabilityFinding(source) && source;
};

/**
 * This Wrapper component renders the children if the given row is a CspVulnerabilityFinding
 * it uses React's Render Props pattern
 */
const CspVulnerabilityFindingRenderer = ({
  row,
  children
}) => {
  const finding = getCspVulnerabilityFinding(row.raw._source);
  if (!finding) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return children({
    finding
  });
};
const flyoutComponent = (row, onCloseFlyout) => {
  return /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
    row: row
  }, ({
    finding
  }) => /*#__PURE__*/_react.default.createElement(_vulnerability_finding_flyout.VulnerabilityFindingFlyout, {
    vulnerabilityRecord: finding,
    closeFlyout: onCloseFlyout
  }));
};
const title = _i18n.i18n.translate('xpack.csp.findings.latestVulnerabilities.tableRowTypeLabel', {
  defaultMessage: 'Vulnerabilities'
});
const customCellRenderer = rows => ({
  'vulnerability.score.base': ({
    rowIndex
  }) => /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
    row: rows[rowIndex]
  }, ({
    finding
  }) => {
    var _finding$vulnerabilit, _finding$vulnerabilit2, _finding$vulnerabilit3, _finding$vulnerabilit4;
    return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CVSScoreBadge, {
      score: (_finding$vulnerabilit = finding.vulnerability) === null || _finding$vulnerabilit === void 0 ? void 0 : (_finding$vulnerabilit2 = _finding$vulnerabilit.score) === null || _finding$vulnerabilit2 === void 0 ? void 0 : _finding$vulnerabilit2.base,
      version: (_finding$vulnerabilit3 = finding.vulnerability) === null || _finding$vulnerabilit3 === void 0 ? void 0 : (_finding$vulnerabilit4 = _finding$vulnerabilit3.score) === null || _finding$vulnerabilit4 === void 0 ? void 0 : _finding$vulnerabilit4.version
    });
  }),
  'vulnerability.severity': ({
    rowIndex
  }) => /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
    row: rows[rowIndex]
  }, ({
    finding
  }) => /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.SeverityStatusBadge, {
    severity: finding.vulnerability.severity
  })),
  'observer.vendor': ({
    rowIndex
  }) => /*#__PURE__*/_react.default.createElement(CspVulnerabilityFindingRenderer, {
    row: rows[rowIndex]
  }, ({
    finding
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _get_vendor_name.getVendorName)(finding) || '-'))
});
const LatestVulnerabilitiesTable = ({
  groupSelectorComponent,
  height,
  nonPersistedFilters
}) => {
  const {
    cloudPostureDataTable,
    rows,
    total,
    error,
    isFetching,
    fetchNextPage
  } = (0, _use_latest_vulnerabilities_table.useLatestVulnerabilitiesTable)({
    getDefaultQuery: _constants.getDefaultQuery,
    nonPersistedFilters
  });
  const createVulnerabilityRuleFn = rowIndex => {
    const vulnerabilityFinding = getCspVulnerabilityFinding(rows[rowIndex].raw._source);
    if (!vulnerabilityFinding) return;
    return async http => (0, _create_detection_rule_from_vulnerability.createDetectionRuleFromVulnerabilityFinding)(http, vulnerabilityFinding);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    error: error
  })) : /*#__PURE__*/_react.default.createElement(_cloud_security_data_table.CloudSecurityDataTable, {
    "data-test-subj": _test_subjects.LATEST_VULNERABILITIES_TABLE,
    isLoading: isFetching,
    defaultColumns: _constants.defaultColumns,
    rows: rows,
    total: total,
    flyoutComponent: flyoutComponent,
    createRuleFn: createVulnerabilityRuleFn,
    cloudPostureDataTable: cloudPostureDataTable,
    loadMore: fetchNextPage,
    title: title,
    customCellRenderer: customCellRenderer,
    groupSelectorComponent: groupSelectorComponent,
    height: height,
    hasDistributionBar: false,
    columnHeaders: _vulnerabilities_table_field_labels.vulnerabilitiesTableFieldLabels
  }));
};
exports.LatestVulnerabilitiesTable = LatestVulnerabilitiesTable;