"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupStatsRenderer = exports.groupPanelRenderer = exports.ComplianceBarComponent = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _constants = require("../../../common/constants");
var _cloud_security_grouping = require("../../../components/cloud_security_grouping");
var _cis_benchmark_icon = require("../../../components/cis_benchmark_icon");
var _compliance_score_bar = require("../../../components/compliance_score_bar");
var _constants2 = require("./constants");
var _test_subjects = require("../test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupPanelRenderer = (selectedGroup, bucket, nullGroupMessage, isLoading) => {
  var _bucket$benchmarkId, _bucket$benchmarkId$b, _bucket$benchmarkId$b2, _bucket$resourceName, _bucket$resourceName$, _bucket$resourceName$2, _bucket$resourceName2, _bucket$resourceName3, _bucket$resourceName4, _bucket$resourceSubTy, _bucket$resourceSubTy2, _bucket$resourceSubTy3, _bucket$benchmarkName, _bucket$benchmarkName2, _bucket$benchmarkName3, _bucket$benchmarkVers, _bucket$benchmarkVers2, _bucket$benchmarkVers3, _bucket$benchmarkName4, _bucket$benchmarkName5, _bucket$benchmarkName6, _bucket$benchmarkName7, _bucket$benchmarkName8, _bucket$benchmarkName9, _bucket$benchmarkName10, _bucket$benchmarkName11, _bucket$benchmarkName12, _bucket$benchmarkName13, _bucket$benchmarkName14, _bucket$benchmarkName15;
  if (isLoading) {
    return /*#__PURE__*/_react2.default.createElement(_cloud_security_grouping.LoadingGroup, null);
  }
  const benchmarkId = (0, _cloud_security_grouping.firstNonNullValue)((_bucket$benchmarkId = bucket.benchmarkId) === null || _bucket$benchmarkId === void 0 ? void 0 : (_bucket$benchmarkId$b = _bucket$benchmarkId.buckets) === null || _bucket$benchmarkId$b === void 0 ? void 0 : (_bucket$benchmarkId$b2 = _bucket$benchmarkId$b[0]) === null || _bucket$benchmarkId$b2 === void 0 ? void 0 : _bucket$benchmarkId$b2.key);
  const renderNullGroup = title => /*#__PURE__*/_react2.default.createElement(_cloud_security_grouping.NullGroup, {
    title: title,
    field: selectedGroup,
    unit: _constants2.NULL_GROUPING_UNIT
  });
  switch (selectedGroup) {
    case _constants.FINDINGS_GROUPING_OPTIONS.RESOURCE_NAME:
      return nullGroupMessage ? renderNullGroup(_constants2.NULL_GROUPING_MESSAGES.RESOURCE_NAME) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        css: (0, _react.css)`
                  display: inline;
                `
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextBlockTruncate, {
        lines: 2,
        css: (0, _react.css)`
                      word-break: break-all;
                    `,
        title: (_bucket$resourceName = bucket.resourceName) === null || _bucket$resourceName === void 0 ? void 0 : (_bucket$resourceName$ = _bucket$resourceName.buckets) === null || _bucket$resourceName$ === void 0 ? void 0 : (_bucket$resourceName$2 = _bucket$resourceName$[0]) === null || _bucket$resourceName$2 === void 0 ? void 0 : _bucket$resourceName$2.key
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string), " ", (_bucket$resourceName2 = bucket.resourceName) === null || _bucket$resourceName2 === void 0 ? void 0 : (_bucket$resourceName3 = _bucket$resourceName2.buckets) === null || _bucket$resourceName3 === void 0 ? void 0 : (_bucket$resourceName4 = _bucket$resourceName3[0]) === null || _bucket$resourceName4 === void 0 ? void 0 : _bucket$resourceName4.key))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, (_bucket$resourceSubTy = bucket.resourceSubType) === null || _bucket$resourceSubTy === void 0 ? void 0 : (_bucket$resourceSubTy2 = _bucket$resourceSubTy.buckets) === null || _bucket$resourceSubTy2 === void 0 ? void 0 : (_bucket$resourceSubTy3 = _bucket$resourceSubTy2[0]) === null || _bucket$resourceSubTy3 === void 0 ? void 0 : _bucket$resourceSubTy3.key)))));
    case _constants.FINDINGS_GROUPING_OPTIONS.RULE_NAME:
      return nullGroupMessage ? renderNullGroup(_constants2.NULL_GROUPING_MESSAGES.RULE_NAME) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, (0, _cloud_security_grouping.firstNonNullValue)((_bucket$benchmarkName = bucket.benchmarkName) === null || _bucket$benchmarkName === void 0 ? void 0 : (_bucket$benchmarkName2 = _bucket$benchmarkName.buckets) === null || _bucket$benchmarkName2 === void 0 ? void 0 : (_bucket$benchmarkName3 = _bucket$benchmarkName2[0]) === null || _bucket$benchmarkName3 === void 0 ? void 0 : _bucket$benchmarkName3.key), ' ', (0, _cloud_security_grouping.firstNonNullValue)((_bucket$benchmarkVers = bucket.benchmarkVersion) === null || _bucket$benchmarkVers === void 0 ? void 0 : (_bucket$benchmarkVers2 = _bucket$benchmarkVers.buckets) === null || _bucket$benchmarkVers2 === void 0 ? void 0 : (_bucket$benchmarkVers3 = _bucket$benchmarkVers2[0]) === null || _bucket$benchmarkVers3 === void 0 ? void 0 : _bucket$benchmarkVers3.key))))));
    case _constants.FINDINGS_GROUPING_OPTIONS.CLOUD_ACCOUNT_NAME:
      return nullGroupMessage ? renderNullGroup(_constants2.NULL_GROUPING_MESSAGES.CLOUD_ACCOUNT_NAME) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "m"
      }, benchmarkId && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: 0
      }, /*#__PURE__*/_react2.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
        type: benchmarkId,
        name: (0, _cloud_security_grouping.firstNonNullValue)((_bucket$benchmarkName4 = bucket.benchmarkName) === null || _bucket$benchmarkName4 === void 0 ? void 0 : (_bucket$benchmarkName5 = _bucket$benchmarkName4.buckets) === null || _bucket$benchmarkName5 === void 0 ? void 0 : (_bucket$benchmarkName6 = _bucket$benchmarkName5[0]) === null || _bucket$benchmarkName6 === void 0 ? void 0 : _bucket$benchmarkName6.key)
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, (_bucket$benchmarkName7 = bucket.benchmarkName) === null || _bucket$benchmarkName7 === void 0 ? void 0 : (_bucket$benchmarkName8 = _bucket$benchmarkName7.buckets) === null || _bucket$benchmarkName8 === void 0 ? void 0 : (_bucket$benchmarkName9 = _bucket$benchmarkName8[0]) === null || _bucket$benchmarkName9 === void 0 ? void 0 : _bucket$benchmarkName9.key)))));
    case _constants.FINDINGS_GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_NAME:
      return nullGroupMessage ? renderNullGroup(_constants2.NULL_GROUPING_MESSAGES.ORCHESTRATOR_CLUSTER_NAME) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "m"
      }, benchmarkId && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: 0
      }, /*#__PURE__*/_react2.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
        type: benchmarkId,
        name: (0, _cloud_security_grouping.firstNonNullValue)((_bucket$benchmarkName10 = bucket.benchmarkName) === null || _bucket$benchmarkName10 === void 0 ? void 0 : (_bucket$benchmarkName11 = _bucket$benchmarkName10.buckets) === null || _bucket$benchmarkName11 === void 0 ? void 0 : (_bucket$benchmarkName12 = _bucket$benchmarkName11[0]) === null || _bucket$benchmarkName12 === void 0 ? void 0 : _bucket$benchmarkName12.key)
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, (_bucket$benchmarkName13 = bucket.benchmarkName) === null || _bucket$benchmarkName13 === void 0 ? void 0 : (_bucket$benchmarkName14 = _bucket$benchmarkName13.buckets) === null || _bucket$benchmarkName14 === void 0 ? void 0 : (_bucket$benchmarkName15 = _bucket$benchmarkName14[0]) === null || _bucket$benchmarkName15 === void 0 ? void 0 : _bucket$benchmarkName15.key)))));
    default:
      return nullGroupMessage ? renderNullGroup(_constants2.NULL_GROUPING_MESSAGES.DEFAULT) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string))))));
  }
};
exports.groupPanelRenderer = groupPanelRenderer;
const FindingsCountComponent = ({
  bucket
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: bucket.doc_count
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    css: (0, _react.css)`
          margin-left: ${euiTheme.size.s};
        `,
    color: "hollow",
    "data-test-subj": _test_subjects.FINDINGS_GROUPING_COUNTER
  }, (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(bucket.doc_count)));
};
const FindingsCount = /*#__PURE__*/_react2.default.memo(FindingsCountComponent);
const ComplianceBarComponent = ({
  bucket
}) => {
  var _bucket$failedFinding, _bucket$passedFinding;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const totalFailed = ((_bucket$failedFinding = bucket.failedFindings) === null || _bucket$failedFinding === void 0 ? void 0 : _bucket$failedFinding.doc_count) || 0;
  const totalPassed = ((_bucket$passedFinding = bucket.passedFindings) === null || _bucket$passedFinding === void 0 ? void 0 : _bucket$passedFinding.doc_count) || 0;
  return /*#__PURE__*/_react2.default.createElement(_compliance_score_bar.ComplianceScoreBar, {
    size: "l",
    overrideCss: (0, _react.css)`
        width: 104px;
        margin-left: ${euiTheme.size.s};
      `,
    totalFailed: totalFailed,
    totalPassed: totalPassed
  });
};
exports.ComplianceBarComponent = ComplianceBarComponent;
const ComplianceBar = /*#__PURE__*/_react2.default.memo(ComplianceBarComponent);
const groupStatsRenderer = (selectedGroup, bucket) => [{
  title: _i18n.i18n.translate('xpack.csp.findings.grouping.stats.badges.findings', {
    defaultMessage: 'Findings'
  }),
  component: /*#__PURE__*/_react2.default.createElement(FindingsCount, {
    bucket: bucket
  })
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.grouping.stats.badges.compliance', {
    defaultMessage: 'Compliance'
  }),
  component: /*#__PURE__*/_react2.default.createElement(ComplianceBar, {
    bucket: bucket
  })
}];
exports.groupStatsRenderer = groupStatsRenderer;