"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupingTitle = exports.getDefaultQuery = exports.defaultGroupingOptions = exports.defaultColumns = exports.NULL_GROUPING_UNIT = exports.NULL_GROUPING_MESSAGES = exports.MISCONFIGURATIONS_GROUPS_UNIT = exports.FINDINGS_UNIT = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FINDINGS_UNIT = totalCount => _i18n.i18n.translate('xpack.csp.findings.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {finding} other {findings}}`
});
exports.FINDINGS_UNIT = FINDINGS_UNIT;
const MISCONFIGURATIONS_GROUPS_UNIT = (totalCount, selectedGroup, hasNullGroup) => {
  const groupCount = hasNullGroup ? totalCount - 1 : totalCount;
  switch (selectedGroup) {
    case _constants.FINDINGS_GROUPING_OPTIONS.RESOURCE_NAME:
      return _i18n.i18n.translate('xpack.csp.findings.groupUnit.resource', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {resource} other {resources}}`
      });
    case _constants.FINDINGS_GROUPING_OPTIONS.RULE_NAME:
      return _i18n.i18n.translate('xpack.csp.findings.groupUnit.rule', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {rule} other {rules}}`
      });
    case _constants.FINDINGS_GROUPING_OPTIONS.CLOUD_ACCOUNT_NAME:
      return _i18n.i18n.translate('xpack.csp.findings.groupUnit.cloudAccount', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {cloud account} other {cloud accounts}}`
      });
    case _constants.FINDINGS_GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_NAME:
      return _i18n.i18n.translate('xpack.csp.findings.groupUnit.kubernetes', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {kubernetes cluster} other {kubernetes clusters}}`
      });
    default:
      return _i18n.i18n.translate('xpack.csp.findings.groupUnit', {
        values: {
          groupCount: totalCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {group} other {groups}}`
      });
  }
};
exports.MISCONFIGURATIONS_GROUPS_UNIT = MISCONFIGURATIONS_GROUPS_UNIT;
const NULL_GROUPING_UNIT = exports.NULL_GROUPING_UNIT = _i18n.i18n.translate('xpack.csp.findings.grouping.nullGroupUnit', {
  defaultMessage: 'findings'
});
const NULL_GROUPING_MESSAGES = exports.NULL_GROUPING_MESSAGES = {
  RESOURCE_NAME: _i18n.i18n.translate('xpack.csp.findings.grouping.resource.nullGroupTitle', {
    defaultMessage: 'No resource'
  }),
  RULE_NAME: _i18n.i18n.translate('xpack.csp.findings.grouping.rule.nullGroupTitle', {
    defaultMessage: 'No rule'
  }),
  CLOUD_ACCOUNT_NAME: _i18n.i18n.translate('xpack.csp.findings.grouping.cloudAccount.nullGroupTitle', {
    defaultMessage: 'No cloud account'
  }),
  ORCHESTRATOR_CLUSTER_NAME: _i18n.i18n.translate('xpack.csp.findings.grouping.kubernetes.nullGroupTitle', {
    defaultMessage: 'No Kubernetes cluster'
  }),
  DEFAULT: _i18n.i18n.translate('xpack.csp.findings.grouping.default.nullGroupTitle', {
    defaultMessage: 'No grouping'
  })
};
const defaultGroupingOptions = exports.defaultGroupingOptions = [{
  label: _i18n.i18n.translate('xpack.csp.findings.latestFindings.groupByResource', {
    defaultMessage: 'Resource'
  }),
  key: _constants.FINDINGS_GROUPING_OPTIONS.RESOURCE_NAME
}, {
  label: _i18n.i18n.translate('xpack.csp.findings.latestFindings.groupByRuleName', {
    defaultMessage: 'Rule name'
  }),
  key: _constants.FINDINGS_GROUPING_OPTIONS.RULE_NAME
}, {
  label: _i18n.i18n.translate('xpack.csp.findings.latestFindings.groupByCloudAccount', {
    defaultMessage: 'Cloud account'
  }),
  key: _constants.FINDINGS_GROUPING_OPTIONS.CLOUD_ACCOUNT_NAME
}, {
  label: _i18n.i18n.translate('xpack.csp.findings.latestFindings.groupByKubernetesCluster', {
    defaultMessage: 'Kubernetes cluster'
  }),
  key: _constants.FINDINGS_GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_NAME
}];
const groupingTitle = exports.groupingTitle = _i18n.i18n.translate('xpack.csp.findings.latestFindings.groupBy', {
  defaultMessage: 'Group findings by'
});
const getDefaultQuery = ({
  query,
  filters
}) => ({
  query,
  filters,
  sort: [['@timestamp', 'desc']]
});
exports.getDefaultQuery = getDefaultQuery;
const defaultColumns = exports.defaultColumns = [{
  id: 'result.evaluation',
  width: 80
}, {
  id: 'resource.id'
}, {
  id: 'resource.name'
}, {
  id: 'resource.sub_type'
}, {
  id: 'rule.benchmark.rule_number'
}, {
  id: 'rule.name'
}, {
  id: 'rule.section'
}, {
  id: 'observer.vendor'
}, {
  id: '@timestamp'
}];