"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPolicyTemplateQuery = exports.dashboardColumnsGrow = exports.SummarySection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _use_navigate_findings = require("@kbn/cloud-security-posture/src/hooks/use_navigate_findings");
var _use_csp_integration_link = require("../../../common/navigation/use_csp_integration_link");
var _test_subjects = require("../test_subjects");
var _csp_counter_card = require("../../../components/csp_counter_card");
var _compact_formatted_number = require("../../../components/compact_formatted_number");
var _chart_panel = require("../../../components/chart_panel");
var _compliance_score_chart = require("../compliance_charts/compliance_score_chart");
var _risks_table = require("../compliance_charts/risks_table");
var _constants = require("../../../../common/constants");
var _accounts_evaluated_widget = require("../../../components/accounts_evaluated_widget");
var _constants2 = require("../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dashboardColumnsGrow = exports.dashboardColumnsGrow = {
  first: 3,
  second: 8,
  third: 8
};
const getPolicyTemplateQuery = policyTemplate => ({
  'rule.benchmark.posture_type': policyTemplate
});
exports.getPolicyTemplateQuery = getPolicyTemplateQuery;
const SummarySection = ({
  dashboardType,
  complianceData
}) => {
  const navToFindings = (0, _use_navigate_findings.useNavigateFindings)();
  const cspmIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE);
  const kspmIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleEvalCounterClick = evaluation => {
    navToFindings({
      'result.evaluation': evaluation,
      ...getPolicyTemplateQuery(dashboardType)
    }, [_constants2.FINDINGS_GROUPING_OPTIONS.NONE]);
  };
  const handleCellClick = (ruleSection, resultEvaluation = _constants.RULE_FAILED) => {
    navToFindings({
      ...getPolicyTemplateQuery(dashboardType),
      'rule.section': ruleSection,
      'result.evaluation': resultEvaluation
    }, [_constants2.FINDINGS_GROUPING_OPTIONS.NONE]);
  };
  const handleViewAllClick = () => {
    navToFindings({
      'result.evaluation': _constants.RULE_FAILED,
      ...getPolicyTemplateQuery(dashboardType)
    }, [_constants2.FINDINGS_GROUPING_OPTIONS.RULE_SECTION]);
  };
  const counters = (0, _react.useMemo)(() => [{
    id: _test_subjects.DASHBOARD_COUNTER_CARDS.CLUSTERS_EVALUATED,
    description: dashboardType === _cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE ? _i18n.i18n.translate('xpack.csp.dashboard.summarySection.counterCard.clustersEvaluatedDescription', {
      defaultMessage: 'Clusters Evaluated'
    }) : _i18n.i18n.translate('xpack.csp.dashboard.summarySection.counterCard.accountsEvaluatedDescription', {
      defaultMessage: 'Accounts Evaluated'
    }),
    title: /*#__PURE__*/_react.default.createElement(_accounts_evaluated_widget.AccountsEvaluatedWidget, {
      benchmarkAssets: complianceData.benchmarks
    }),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "listAdd",
      target: "_blank",
      href: dashboardType === _cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE ? kspmIntegrationLink : cspmIntegrationLink
    }, dashboardType === _cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE ? _i18n.i18n.translate('xpack.csp.dashboard.summarySection.counterCard.clustersEvaluatedButtonTitle', {
      defaultMessage: 'Enroll more clusters'
    }) : _i18n.i18n.translate('xpack.csp.dashboard.summarySection.counterCard.accountsEvaluatedButtonTitle', {
      defaultMessage: 'Enroll more accounts'
    }))
  }, {
    id: _test_subjects.DASHBOARD_COUNTER_CARDS.RESOURCES_EVALUATED,
    description: _i18n.i18n.translate('xpack.csp.dashboard.summarySection.counterCard.resourcesEvaluatedDescription', {
      defaultMessage: 'Resources Evaluated'
    }),
    title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
      number: complianceData.stats.resourcesEvaluated || 0
    }),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "search",
      "data-test-subj": "dashboard-view-all-resources",
      onClick: () => {
        navToFindings(getPolicyTemplateQuery(dashboardType), [_constants2.FINDINGS_GROUPING_OPTIONS.RESOURCE_NAME]);
      }
    }, _i18n.i18n.translate('xpack.csp.dashboard.summarySection.counterCard.resourcesEvaluatedButtonTitle', {
      defaultMessage: 'View all resources'
    }))
  }], [complianceData.benchmarks, complianceData.stats.resourcesEvaluated, cspmIntegrationLink, dashboardType, kspmIntegrationLink, navToFindings]);
  const chartTitle = _i18n.i18n.translate('xpack.csp.dashboard.summarySection.complianceScorePanelTitle', {
    defaultMessage: 'Compliance Score'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    css: (0, _react2.css)`
        // height for compliance by cis section with max rows
        height: 350px;
      `,
    "data-test-subj": _test_subjects.DASHBOARD_SUMMARY_CONTAINER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: dashboardColumnsGrow.first
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, counters.map(counter => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: counter.id
  }, /*#__PURE__*/_react.default.createElement(_csp_counter_card.CspCounterCard, counter))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: dashboardColumnsGrow.second
  }, /*#__PURE__*/_react.default.createElement(_chart_panel.ChartPanel, {
    title: chartTitle
  }, /*#__PURE__*/_react.default.createElement(_compliance_score_chart.ComplianceScoreChart, {
    id: "cloud_posture_score_chart",
    data: complianceData.stats,
    trend: complianceData.trend,
    onEvalCounterClick: handleEvalCounterClick
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: dashboardColumnsGrow.third
  }, /*#__PURE__*/_react.default.createElement(_chart_panel.ChartPanel, {
    styles: {
      padding: `${euiTheme.size.m} ${euiTheme.size.m} ${euiTheme.size.s} ${euiTheme.size.m}`
    },
    title: _i18n.i18n.translate('xpack.csp.dashboard.summarySection.complianceByCisSectionPanelTitle', {
      defaultMessage: 'Compliance By CIS Section'
    })
  }, /*#__PURE__*/_react.default.createElement(_risks_table.RisksTable, {
    data: complianceData.groupedFindingsEvaluation,
    maxItems: 5,
    onCellClick: cisSection => {
      const cisSectionEvaluation = complianceData.groupedFindingsEvaluation.find(groupedFindingsEvaluation => groupedFindingsEvaluation.name === cisSection);

      // if the CIS Section posture score is 100, we should navigate with result evaluation as passed or result evaluation as failed
      if (cisSectionEvaluation !== null && cisSectionEvaluation !== void 0 && cisSectionEvaluation.postureScore && Math.trunc(cisSectionEvaluation === null || cisSectionEvaluation === void 0 ? void 0 : cisSectionEvaluation.postureScore) === 100) {
        handleCellClick(cisSection, _constants.RULE_PASSED);
      } else {
        handleCellClick(cisSection);
      }
    },
    onViewAllClick: handleViewAllClick,
    viewAllButtonTitle: _i18n.i18n.translate('xpack.csp.dashboard.risksTable.viewAllButtonTitle', {
      defaultMessage: 'View all failed findings'
    })
  }))));
};
exports.SummarySection = SummarySection;