"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetupTechnology = void 0;
var _react = require("react");
var _public = require("@kbn/fleet-plugin/public");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSetupTechnology = ({
  input,
  isAgentlessEnabled,
  handleSetupTechnologyChange,
  isEditPage
}) => {
  const isCspmAws = input.type === _constants.CLOUDBEAT_AWS;
  const isCspmGcp = input.type === _constants.CLOUDBEAT_GCP;
  const isCspmAzure = input.type === _constants.CLOUDBEAT_AZURE;
  const isAgentlessSupportedForCloudProvider = isCspmAws || isCspmGcp || isCspmAzure;
  const isAgentlessAvailable = isAgentlessSupportedForCloudProvider && isAgentlessEnabled;
  const defaultSetupTechnology = isEditPage && isAgentlessAvailable ? _public.SetupTechnology.AGENTLESS : _public.SetupTechnology.AGENT_BASED;
  const [setupTechnology, setSetupTechnology] = (0, _react.useState)(defaultSetupTechnology);
  const updateSetupTechnology = value => {
    setSetupTechnology(value);
    if (handleSetupTechnologyChange) {
      handleSetupTechnologyChange(value);
    }
  };
  return {
    isAgentlessAvailable,
    setupTechnology,
    setSetupTechnology,
    updateSetupTechnology
  };
};
exports.useSetupTechnology = useSetupTechnology;