"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupTechnologySelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/fleet-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _test_subjects = require("../../test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetupTechnologySelector = ({
  disabled,
  setupTechnology,
  onSetupTechnologyChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const agentlessOptionBadge = isDropDownDisplay => {
    const title = isDropDownDisplay ? /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.agentlessDrowpownDisplay",
      defaultMessage: "Agentless"
    })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.agentlessInputDisplay",
      defaultMessage: "Agentless"
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: {
        paddingTop: !isDropDownDisplay ? euiTheme.size.xs : undefined
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _i18n.i18n.translate('xpack.csp.fleetIntegration.setupTechnology.agentlessInputDisplay.techPreviewBadge.label', {
        defaultMessage: 'Beta'
      }),
      size: "m",
      color: "hollow",
      tooltipContent: _i18n.i18n.translate('xpack.csp.fleetIntegration.setupTechnology.agentlessInputDisplay.techPreviewBadge.tooltip', {
        defaultMessage: 'This functionality is in technical preview and may be changed in a future release. Please help us by reporting any bugs.'
      })
    })));
  };
  const options = [{
    value: _public.SetupTechnology.AGENT_BASED,
    'data-test-subj': 'setup-technology-agent-based-option',
    inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.agentbasedInputDisplay",
      defaultMessage: "Agent-based"
    }),
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.agentbasedDrowpownDisplay",
      defaultMessage: "Agent-based"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.agentbasedDrowpownDescription",
      defaultMessage: "Set up the integration with an agent"
    }))))
  }, {
    value: _public.SetupTechnology.AGENTLESS,
    inputDisplay: agentlessOptionBadge(false),
    'data-test-subj': 'setup-technology-agentless-option',
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, agentlessOptionBadge(true), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.agentlessDrowpownDescription",
      defaultMessage: "Set up the integration without an agent"
    }))))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    isDisabled: disabled,
    initialIsOpen: disabled,
    id: (0, _eui.useGeneratedHtmlId)({
      prefix: 'setup-type'
    }),
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      disabled: disabled
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.advancedOptionsLabel",
      defaultMessage: "Advanced options"
    })),
    "data-test-subj": _test_subjects.SETUP_TECHNOLOGY_SELECTOR_ACCORDION_TEST_SUBJ
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.setupTechnologyLabel",
      defaultMessage: "Setup technology"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled,
    options: options,
    valueOfSelected: setupTechnology,
    placeholder: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.setupTechnologyPlaceholder",
      defaultMessage: "Select the setup technology"
    }),
    onChange: onSetupTechnologyChange,
    itemLayoutAlign: "top",
    hasDividers: true,
    fullWidth: true,
    "data-test-subj": _test_subjects.SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ
  }))));
};
exports.SetupTechnologySelector = SetupTechnologySelector;