"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AzureCredentialsFormAgentless = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/navigation/constants");
var _azure_credentials_form = require("./azure_credentials_form");
var _utils = require("../utils");
var _get_azure_credentials_form_options = require("./get_azure_credentials_form_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AzureCredentialsFormAgentless = ({
  input,
  newPolicy,
  updatePolicy,
  packageInfo
}) => {
  const documentationLink = _constants.cspIntegrationDocsNavigation.cspm.azureGetStartedPath;
  const options = (0, _get_azure_credentials_form_options.getAzureCredentialsFormOptions)();
  const group = options[_azure_credentials_form.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_SECRET];
  const fields = (0, _get_azure_credentials_form_options.getInputVarsFields)(input, group.fields);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_azure_credentials_form.AzureSetupInfoContent, {
    documentationLink: documentationLink
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_azure_credentials_form.AzureInputVarFields, {
    packageInfo: packageInfo,
    fields: fields,
    onChange: (key, value) => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        [key]: {
          value
        }
      }));
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.azureIntegration.armTemplateSetupNote",
    defaultMessage: "Read the {documentation} for more details",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _azure_credentials_form.ARM_TEMPLATE_EXTERNAL_DOC_URL,
        target: "_blank",
        rel: "noopener nofollow noreferrer",
        "data-test-subj": "externalLink"
      }, _i18n.i18n.translate('xpack.csp.azureIntegration.documentationLinkText', {
        defaultMessage: 'documentation'
      }))
    }
  })));
};
exports.AzureCredentialsFormAgentless = AzureCredentialsFormAgentless;