"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AwsInputVarFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/fleet-plugin/public");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AwsInputVarFields = ({
  fields,
  onChange,
  packageInfo
}) => {
  return /*#__PURE__*/_react.default.createElement("div", null, fields.map((field, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index
  }, field.type === 'password' && field.isSecret === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                  width: 100%;
                  .euiFormControlLayout,
                  .euiFormControlLayout__childrenWrapper,
                  .euiFormRow,
                  input {
                    max-width: 100%;
                    width: 100%;
                  }
                `
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    })
  }, /*#__PURE__*/_react.default.createElement(_public.LazyPackagePolicyInputVarField, {
    varDef: {
      ...(0, _utils.findVariableDef)(packageInfo, field.id),
      required: true,
      type: 'password'
    },
    value: field.value || '',
    onChange: value => {
      onChange(field.id, value);
    },
    errors: [],
    forceShowErrors: false,
    isEditPage: true,
    "data-test-subj": field.dataTestSubj
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), field.type === 'text' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    key: field.id,
    label: field.label,
    fullWidth: true,
    hasChildLabel: true,
    id: field.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    id: field.id,
    fullWidth: true,
    value: field.value || '',
    onChange: event => onChange(field.id, event.target.value),
    "data-test-subj": field.dataTestSubj
  })))));
};
exports.AwsInputVarFields = AwsInputVarFields;