"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudFormationCloudCredentialsGuide = exports.AwsCredentialsFormAgentless = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _compare = _interopRequireDefault(require("semver/functions/compare"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _i18n = require("@kbn/i18n");
var _get_template_url_package_info = require("../../../common/utils/get_template_url_package_info");
var _constants = require("../../../common/navigation/constants");
var _constants2 = require("../../../../common/constants");
var _get_aws_credentials_form_options = require("./get_aws_credentials_form_options");
var _utils = require("../utils");
var _aws_input_var_fields = require("./aws_input_var_fields");
var _aws_credentials_form = require("./aws_credentials_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_FORMATION_EXTERNAL_DOC_URL = 'https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-howdoesitwork.html';
const CloudFormationCloudCredentialsGuide = ({
  isOrganization
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.cloudFormation.guide.description",
    defaultMessage: "Access keys are long-term credentials for an IAM user or the AWS account root user.\nUtilize AWS CloudFormation (a built-in AWS tool) or a series of manual steps to set up access. {learnMore}.",
    values: {
      learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: CLOUD_FORMATION_EXTERNAL_DOC_URL,
        target: "_blank",
        rel: "noopener nofollow noreferrer",
        "data-test-subj": "externalLink"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.agentlessForm.cloudFormation.guide.learnMoreLinkText",
        defaultMessage: "Learn more about CloudFormation"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("ol", null, isOrganization ? /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.cloudFormation.guide.steps.organizationLogin",
    defaultMessage: "Log in as an {admin} in the management account of the AWS Organization you want to onboard",
    values: {
      admin: /*#__PURE__*/_react.default.createElement("strong", null, "admin")
    }
  })) : /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.cloudFormation.guide.steps.singleLogin",
    defaultMessage: "Log in as an {admin} in the AWS account you want to onboard",
    values: {
      admin: /*#__PURE__*/_react.default.createElement("strong", null, "admin")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.cloudFormation.guide.steps.launch",
    defaultMessage: "Click the {launchCloudFormation} button below.",
    values: {
      launchCloudFormation: /*#__PURE__*/_react.default.createElement("strong", null, "Launch CloudFormation")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.cloudFormation.steps.region",
    defaultMessage: "(Optional) Change the {amazonRegion} in the upper right corner to the region you want to deploy your stack to",
    values: {
      amazonRegion: /*#__PURE__*/_react.default.createElement("strong", null, "AWS region")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.cloudFormation.steps.accept",
    defaultMessage: "Tick the checkbox under {capabilities} in the opened CloudFormation stack review form: {acknowledge}",
    values: {
      acknowledge: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.agentlessForm.cloudFormation.steps.accept.acknowledge",
        defaultMessage: "I acknowledge that AWS CloudFormation might create IAM resources."
      })),
      capabilities: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.agentlessForm.cloudFormation.steps.accept.capabilties",
        defaultMessage: "capabilities"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.cloudFormation.steps.create",
    defaultMessage: "Click {createStack}.",
    values: {
      createStack: /*#__PURE__*/_react.default.createElement("strong", null, "Create stack")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.cloudFormation.steps.stackStatus",
    defaultMessage: "Once  stack status is {createComplete} then click the Outputs tab",
    values: {
      createComplete: /*#__PURE__*/_react.default.createElement("strong", null, "CREATE_COMPLETE")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.cloudFormation.steps.credentials",
    defaultMessage: "Copy {accessKeyId} and {secretAccessKey} then paste the credentials below",
    values: {
      accessKeyId: /*#__PURE__*/_react.default.createElement("strong", null, "Access Key Id"),
      secretAccessKey: /*#__PURE__*/_react.default.createElement("strong", null, "Secret Access Key")
    }
  })))));
};
exports.CloudFormationCloudCredentialsGuide = CloudFormationCloudCredentialsGuide;
const AwsCredentialsFormAgentless = ({
  input,
  newPolicy,
  packageInfo,
  updatePolicy
}) => {
  var _input$streams$0$vars, _input$streams, _input$streams$0$vars2, _input$streams$0$vars3, _getTemplateUrlFromPa;
  const awsCredentialsType = (0, _utils.getAwsCredentialsType)(input) || _get_aws_credentials_form_options.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE;
  const options = (0, _get_aws_credentials_form_options.getAwsCredentialsFormOptions)();
  const group = options[awsCredentialsType];
  const fields = (0, _get_aws_credentials_form_options.getInputVarsFields)(input, group.fields);
  const documentationLink = _constants.cspIntegrationDocsNavigation.cspm.awsGetStartedPath;
  const accountType = (_input$streams$0$vars = input === null || input === void 0 ? void 0 : (_input$streams = input.streams) === null || _input$streams === void 0 ? void 0 : (_input$streams$0$vars2 = _input$streams[0].vars) === null || _input$streams$0$vars2 === void 0 ? void 0 : (_input$streams$0$vars3 = _input$streams$0$vars2['aws.account_type']) === null || _input$streams$0$vars3 === void 0 ? void 0 : _input$streams$0$vars3.value) !== null && _input$streams$0$vars !== void 0 ? _input$streams$0$vars : _constants2.SINGLE_ACCOUNT;
  const isValidSemantic = (0, _valid.default)(packageInfo.version);
  const showCloudCredentialsButton = isValidSemantic ? (0, _compare.default)(packageInfo.version, _constants2.CLOUD_CREDENTIALS_PACKAGE_VERSION) >= 0 : false;
  const automationCredentialTemplate = (_getTemplateUrlFromPa = (0, _get_template_url_package_info.getTemplateUrlFromPackageInfo)(packageInfo, input.policy_template, _get_template_url_package_info.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS.CLOUD_FORMATION_CREDENTIALS)) === null || _getTemplateUrlFromPa === void 0 ? void 0 : _getTemplateUrlFromPa.replace(_constants2.TEMPLATE_URL_ACCOUNT_TYPE_ENV_VAR, accountType);
  const isOrganization = accountType === _constants2.ORGANIZATION_ACCOUNT;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_aws_credentials_form.AWSSetupInfoContent, {
    info: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.awsIntegration.gettingStarted.setupInfoContentAgentless",
      defaultMessage: "Utilize AWS Access Keys to set up and deploy CSPM for assessing your AWS environment's security posture. Refer to our {gettingStartedLink} guide for details.",
      values: {
        gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: documentationLink,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.awsIntegration.gettingStarted.setupInfoContentLink",
          defaultMessage: "Getting Started"
        }))
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.AwsCredentialTypeSelector, {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.awsCredentialTypeSelectorLabelAgentless', {
      defaultMessage: 'Preferred method'
    }),
    type: awsCredentialsType,
    options: (0, _get_aws_credentials_form_options.getAwsCredentialsFormAgentlessOptions)(),
    onChange: optionId => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'aws.credentials.type': {
          value: optionId
        }
      }));
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), awsCredentialsType === _get_aws_credentials_form_options.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE && !showCloudCredentialsButton && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.awsCloudCredentials.cloudFormationSupportedMessage",
    defaultMessage: "Launch Cloud Formation for Automated Credentials not supported in current integration version. Please upgrade to the latest version to enable Launch CloudFormation for automated credentials."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), awsCredentialsType === _get_aws_credentials_form_options.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE && showCloudCredentialsButton && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "cloudFormationAccordianInstructions",
    "data-test-subj": "launchGoogleCloudFormationAccordianInstructions",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, null, "Steps to Generate AWS Account Credentials"),
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(CloudFormationCloudCredentialsGuide, {
    isOrganization: isOrganization
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "launchCloudFormationAgentlessButton",
    target: "_blank",
    iconSide: "left",
    iconType: "launch",
    href: automationCredentialTemplate
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.agentlessAWSCredentialsForm.cloudFormation.launchButton",
    defaultMessage: "Launch CloudFormation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_aws_input_var_fields.AwsInputVarFields, {
    fields: fields,
    packageInfo: packageInfo,
    onChange: (key, value) => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        [key]: {
          value
        }
      }));
    }
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.ReadDocumentation, {
    url: documentationLink
  }));
};
exports.AwsCredentialsFormAgentless = AwsCredentialsFormAgentless;