"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloudPostureIntegrations = exports.VULNERABILITY_GROUPING_OPTIONS = exports.VULNERABILITY_FIELDS = exports.SESSION_STORAGE_FIELDS_MODAL_SHOW_SELECTED = exports.NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS = exports.MIN_VERSION_GCP_CIS = exports.LOCAL_STORAGE_VULNERABILITIES_GROUPING_KEY = exports.LOCAL_STORAGE_PAGE_SIZE_RULES_KEY = exports.LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY = exports.LOCAL_STORAGE_FINDINGS_LAST_SELECTED_TAB_KEY = exports.LOCAL_STORAGE_FINDINGS_GROUPING_KEY = exports.LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY = exports.LOCAL_STORAGE_DATA_TABLE_COLUMNS_KEY = exports.LOCAL_STORAGE_DASHBOARD_BENCHMARK_SORT_KEY = exports.LOCAL_STORAGE_3P_INTEGRATIONS_CALLOUT_KEY = exports.FINDINGS_GROUPING_OPTIONS = exports.FINDINGS_DOCS_URL = exports.DETECTION_ENGINE_RULES_KEY = exports.DETECTION_ENGINE_ALERTS_KEY = exports.DEFAULT_VISIBLE_ROWS_PER_PAGE = exports.DEFAULT_GROUPING_TABLE_HEIGHT = exports.CSP_MOMENT_FORMAT = exports.CDR_VULNERABILITY_GROUPING_RUNTIME_MAPPING_FIELDS = exports.CDR_VULNERABILITY_DATA_TABLE_RUNTIME_MAPPING_FIELDS = exports.CDR_MISCONFIGURATION_GROUPING_RUNTIME_MAPPING_FIELDS = exports.CDR_MISCONFIGURATION_DATA_TABLE_RUNTIME_MAPPING_FIELDS = void 0;
var _i18n = require("@kbn/i18n");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _constants = require("../../common/constants");
var _cis_eks_logo = _interopRequireDefault(require("../assets/icons/cis_eks_logo.svg"));
var _cis_aks_logo = _interopRequireDefault(require("../assets/icons/cis_aks_logo.svg"));
var _cis_gke_logo = _interopRequireDefault(require("../assets/icons/cis_gke_logo.svg"));
var _google_cloud_logo = _interopRequireDefault(require("../assets/icons/google_cloud_logo.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CSP_MOMENT_FORMAT = exports.CSP_MOMENT_FORMAT = 'MMMM D, YYYY @ HH:mm:ss.SSS';
const DEFAULT_VISIBLE_ROWS_PER_PAGE = exports.DEFAULT_VISIBLE_ROWS_PER_PAGE = 25;
const LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY = exports.LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY = 'cloudPosture:dataTable:pageSize';
const LOCAL_STORAGE_DATA_TABLE_COLUMNS_KEY = exports.LOCAL_STORAGE_DATA_TABLE_COLUMNS_KEY = 'cloudPosture:dataTable:columns';
const LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY = exports.LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY = 'cloudPosture:benchmark:pageSize';
const LOCAL_STORAGE_PAGE_SIZE_RULES_KEY = exports.LOCAL_STORAGE_PAGE_SIZE_RULES_KEY = 'cloudPosture:rules:pageSize';
const LOCAL_STORAGE_DASHBOARD_BENCHMARK_SORT_KEY = exports.LOCAL_STORAGE_DASHBOARD_BENCHMARK_SORT_KEY = 'cloudPosture:complianceDashboard:benchmarkSort';
const LOCAL_STORAGE_FINDINGS_LAST_SELECTED_TAB_KEY = exports.LOCAL_STORAGE_FINDINGS_LAST_SELECTED_TAB_KEY = 'cloudPosture:findings:lastSelectedTab';
const LOCAL_STORAGE_3P_INTEGRATIONS_CALLOUT_KEY = exports.LOCAL_STORAGE_3P_INTEGRATIONS_CALLOUT_KEY = 'cloudPosture:findings:3pIntegrationsCallout';
const LOCAL_STORAGE_VULNERABILITIES_GROUPING_KEY = exports.LOCAL_STORAGE_VULNERABILITIES_GROUPING_KEY = 'cspLatestVulnerabilitiesGrouping';
const LOCAL_STORAGE_FINDINGS_GROUPING_KEY = exports.LOCAL_STORAGE_FINDINGS_GROUPING_KEY = 'cspLatestFindingsGrouping';
const SESSION_STORAGE_FIELDS_MODAL_SHOW_SELECTED = exports.SESSION_STORAGE_FIELDS_MODAL_SHOW_SELECTED = 'cloudPosture:fieldsModal:showSelected';
const cloudPostureIntegrations = exports.cloudPostureIntegrations = {
  cspm: {
    policyTemplate: _cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE,
    name: _i18n.i18n.translate('xpack.csp.cspmIntegration.integration.nameTitle', {
      defaultMessage: 'Cloud Security Posture Management'
    }),
    shortName: _i18n.i18n.translate('xpack.csp.cspmIntegration.integration.shortNameTitle', {
      defaultMessage: 'CSPM'
    }),
    options: [{
      type: _constants.CLOUDBEAT_AWS,
      name: _i18n.i18n.translate('xpack.csp.cspmIntegration.awsOption.nameTitle', {
        defaultMessage: 'AWS'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.cspmIntegration.awsOption.benchmarkTitle', {
        defaultMessage: 'CIS AWS'
      }),
      icon: 'logoAWS',
      testId: 'cisAwsTestId'
    }, {
      type: _constants.CLOUDBEAT_GCP,
      name: _i18n.i18n.translate('xpack.csp.cspmIntegration.gcpOption.nameTitle', {
        defaultMessage: 'GCP'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.cspmIntegration.gcpOption.benchmarkTitle', {
        defaultMessage: 'CIS GCP'
      }),
      icon: _google_cloud_logo.default,
      testId: 'cisGcpTestId'
    }, {
      type: _constants.CLOUDBEAT_AZURE,
      name: _i18n.i18n.translate('xpack.csp.cspmIntegration.azureOption.nameTitle', {
        defaultMessage: 'Azure'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.cspmIntegration.azureOption.benchmarkTitle', {
        defaultMessage: 'CIS Azure'
      }),
      icon: 'logoAzure',
      testId: 'cisAzureTestId'
    }]
  },
  kspm: {
    policyTemplate: _cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE,
    name: _i18n.i18n.translate('xpack.csp.kspmIntegration.integration.nameTitle', {
      defaultMessage: 'Kubernetes Security Posture Management'
    }),
    shortName: _i18n.i18n.translate('xpack.csp.kspmIntegration.integration.shortNameTitle', {
      defaultMessage: 'KSPM'
    }),
    options: [{
      type: _constants.CLOUDBEAT_VANILLA,
      name: _i18n.i18n.translate('xpack.csp.kspmIntegration.vanillaOption.nameTitle', {
        defaultMessage: 'Self-Managed'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.kspmIntegration.vanillaOption.benchmarkTitle', {
        defaultMessage: 'CIS Kubernetes'
      }),
      icon: 'logoKubernetes',
      testId: 'cisK8sTestId'
    }, {
      type: _constants.CLOUDBEAT_EKS,
      name: _i18n.i18n.translate('xpack.csp.kspmIntegration.eksOption.nameTitle', {
        defaultMessage: 'EKS'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.kspmIntegration.eksOption.benchmarkTitle', {
        defaultMessage: 'CIS EKS'
      }),
      icon: _cis_eks_logo.default,
      tooltip: _i18n.i18n.translate('xpack.csp.kspmIntegration.eksOption.tooltipContent', {
        defaultMessage: 'Elastic Kubernetes Service'
      }),
      testId: 'cisEksTestId'
    }, {
      type: _constants.CLOUDBEAT_AKS,
      name: _i18n.i18n.translate('xpack.csp.kspmIntegration.aksOption.nameTitle', {
        defaultMessage: 'AKS'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.kspmIntegration.aksOption.benchmarkTitle', {
        defaultMessage: 'CIS AKS'
      }),
      disabled: true,
      icon: _cis_aks_logo.default,
      tooltip: _i18n.i18n.translate('xpack.csp.kspmIntegration.aksOption.tooltipContent', {
        defaultMessage: 'Azure Kubernetes Service - Coming soon'
      })
    }, {
      type: _constants.CLOUDBEAT_GKE,
      name: _i18n.i18n.translate('xpack.csp.kspmIntegration.gkeOption.nameTitle', {
        defaultMessage: 'GKE'
      }),
      benchmark: _i18n.i18n.translate('xpack.csp.kspmIntegration.gkeOption.benchmarkTitle', {
        defaultMessage: 'CIS GKE'
      }),
      disabled: true,
      icon: _cis_gke_logo.default,
      tooltip: _i18n.i18n.translate('xpack.csp.kspmIntegration.gkeOption.tooltipContent', {
        defaultMessage: 'Google Kubernetes Engine - Coming soon'
      })
    }]
  },
  vuln_mgmt: {
    policyTemplate: _constants.VULN_MGMT_POLICY_TEMPLATE,
    name: 'Vulnerability Management',
    // TODO: we should use i18n and fix this
    shortName: 'VULN_MGMT',
    // TODO: we should use i18n and fix this
    options: [{
      type: _constants.CLOUDBEAT_VULN_MGMT_AWS,
      name: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.awsOption.nameTitle', {
        defaultMessage: 'Amazon Web Services'
      }),
      icon: 'logoAWS',
      benchmark: 'N/A' // TODO: change benchmark to be optional
    }, {
      type: _constants.CLOUDBEAT_VULN_MGMT_GCP,
      name: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.gcpOption.nameTitle', {
        defaultMessage: 'GCP'
      }),
      disabled: true,
      icon: _google_cloud_logo.default,
      tooltip: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.gcpOption.tooltipContent', {
        defaultMessage: 'Coming soon'
      }),
      benchmark: 'N/A' // TODO: change benchmark to be optional
    }, {
      type: _constants.CLOUDBEAT_VULN_MGMT_AZURE,
      name: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.azureOption.nameTitle', {
        defaultMessage: 'Azure'
      }),
      disabled: true,
      icon: 'logoAzure',
      tooltip: _i18n.i18n.translate('xpack.csp.vulnMgmtIntegration.azureOption.tooltipContent', {
        defaultMessage: 'Coming soon'
      }),
      benchmark: 'N/A' // TODO: change benchmark to be optional
    }]
  }
};
const FINDINGS_DOCS_URL = exports.FINDINGS_DOCS_URL = 'https://ela.st/findings';
const MIN_VERSION_GCP_CIS = exports.MIN_VERSION_GCP_CIS = '1.5.2';
const NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS = exports.NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS = 10000;
const DETECTION_ENGINE_RULES_KEY = exports.DETECTION_ENGINE_RULES_KEY = 'detection_engine_rules';
const DETECTION_ENGINE_ALERTS_KEY = exports.DETECTION_ENGINE_ALERTS_KEY = 'detection_engine_alerts';
const DEFAULT_GROUPING_TABLE_HEIGHT = exports.DEFAULT_GROUPING_TABLE_HEIGHT = 512;
const FINDINGS_GROUPING_OPTIONS = exports.FINDINGS_GROUPING_OPTIONS = {
  NONE: 'none',
  RESOURCE_NAME: 'resource.name',
  RULE_NAME: 'rule.name',
  RULE_SECTION: 'rule.section',
  CLOUD_ACCOUNT_NAME: 'cloud.account.name',
  ORCHESTRATOR_CLUSTER_NAME: 'orchestrator.cluster.name'
};
const VULNERABILITY_FIELDS = exports.VULNERABILITY_FIELDS = {
  VULNERABILITY_ID: 'vulnerability.id',
  SCORE_BASE: 'vulnerability.score.base',
  RESOURCE_NAME: 'resource.name',
  RESOURCE_ID: 'resource.id',
  SEVERITY: 'vulnerability.severity',
  PACKAGE_NAME: 'package.name',
  PACKAGE_VERSION: 'package.version',
  PACKAGE_FIXED_VERSION: 'package.fixed_version',
  CLOUD_ACCOUNT_NAME: 'cloud.account.name',
  CLOUD_PROVIDER: 'cloud.provider',
  DESCRIPTION: 'vulnerability.description',
  VENDOR: 'observer.vendor'
};
const VULNERABILITY_GROUPING_OPTIONS = exports.VULNERABILITY_GROUPING_OPTIONS = {
  NONE: 'none',
  RESOURCE_NAME: VULNERABILITY_FIELDS.RESOURCE_NAME,
  RESOURCE_ID: VULNERABILITY_FIELDS.RESOURCE_ID,
  CLOUD_ACCOUNT_NAME: VULNERABILITY_FIELDS.CLOUD_ACCOUNT_NAME,
  CVE: VULNERABILITY_FIELDS.VULNERABILITY_ID
};

/*
The fields below are default columns of the Cloud Security Data Table that need to have keyword mapping.
The runtime mappings are used to prevent filtering out the data when any of these columns are sorted in the Data Table.
TODO: Remove the fields below once they are mapped as Keyword in the Third Party integrations, or remove
the fields from the runtime mappings if they are removed from the Data Table.
*/
const CDR_VULNERABILITY_DATA_TABLE_RUNTIME_MAPPING_FIELDS = exports.CDR_VULNERABILITY_DATA_TABLE_RUNTIME_MAPPING_FIELDS = [];
const CDR_MISCONFIGURATION_DATA_TABLE_RUNTIME_MAPPING_FIELDS = exports.CDR_MISCONFIGURATION_DATA_TABLE_RUNTIME_MAPPING_FIELDS = ['rule.benchmark.rule_number', 'rule.section', 'resource.sub_type'];

/*
The fields below are used to group the data in the Cloud Security Data Table.
The keys are the fields that are used to group the data, and the values are the fields that need to have keyword mapping
to prevent filtering out the data when grouping by the key field.
TODO: Remove the fields below once they are mapped as Keyword in the Third Party integrations, or remove
the fields from the runtime mappings if they are removed from the Data Table.
*/
const CDR_VULNERABILITY_GROUPING_RUNTIME_MAPPING_FIELDS = exports.CDR_VULNERABILITY_GROUPING_RUNTIME_MAPPING_FIELDS = {};
const CDR_MISCONFIGURATION_GROUPING_RUNTIME_MAPPING_FIELDS = exports.CDR_MISCONFIGURATION_GROUPING_RUNTIME_MAPPING_FIELDS = {
  [FINDINGS_GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_NAME]: ['orchestrator.cluster.name'],
  [FINDINGS_GROUPING_OPTIONS.CLOUD_ACCOUNT_NAME]: ['cloud.account.name']
};