"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiMetricService = exports.VULNERABILITIES_INSIGHT_HOST_ENTITY_OVERVIEW = exports.VULNERABILITIES_INSIGHT_HOST_DETAILS = exports.VULNERABILITIES_INSIGHT = exports.VULNERABILITIES_FLYOUT_VISITS = exports.UiMetricService = exports.OPEN_FINDINGS_FLYOUT = exports.NAV_TO_FINDINGS_BY_RULE_NAME_FRPOM_ENTITY_FLYOUT = exports.NAV_TO_FINDINGS_BY_HOST_NAME_FRPOM_ENTITY_FLYOUT = exports.MISCONFIGURATION_INSIGHT_USER_ENTITY_OVERVIEW = exports.MISCONFIGURATION_INSIGHT_USER_DETAILS = exports.MISCONFIGURATION_INSIGHT_HOST_ENTITY_OVERVIEW = exports.MISCONFIGURATION_INSIGHT_HOST_DETAILS = exports.MISCONFIGURATION_INSIGHT = exports.GROUP_BY_CLICK = exports.ENTITY_FLYOUT_WITH_VULNERABILITY_PREVIEW = exports.ENTITY_FLYOUT_WITH_MISCONFIGURATION_VISIT = exports.ENTITY_FLYOUT_EXPAND_VULNERABILITY_VIEW_VISITS = exports.ENTITY_FLYOUT_EXPAND_MISCONFIGURATION_VIEW_VISITS = exports.CREATE_DETECTION_RULE_FROM_FLYOUT = exports.CREATE_DETECTION_FROM_TABLE_ROW_ACTION = exports.CHANGE_RULE_STATE = exports.APP_NAME = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APP_NAME = exports.APP_NAME = 'cloud-security';
const MISCONFIGURATION_INSIGHT = exports.MISCONFIGURATION_INSIGHT = 'misconfiguration-insight';
const VULNERABILITIES_INSIGHT = exports.VULNERABILITIES_INSIGHT = 'vulnerabilities-insight';
const MISCONFIGURATION_INSIGHT_HOST_DETAILS = exports.MISCONFIGURATION_INSIGHT_HOST_DETAILS = `${MISCONFIGURATION_INSIGHT}-host-details`;
const MISCONFIGURATION_INSIGHT_USER_DETAILS = exports.MISCONFIGURATION_INSIGHT_USER_DETAILS = `${MISCONFIGURATION_INSIGHT}-user-details`;
const MISCONFIGURATION_INSIGHT_HOST_ENTITY_OVERVIEW = exports.MISCONFIGURATION_INSIGHT_HOST_ENTITY_OVERVIEW = `${MISCONFIGURATION_INSIGHT}-host-entity-overview`;
const MISCONFIGURATION_INSIGHT_USER_ENTITY_OVERVIEW = exports.MISCONFIGURATION_INSIGHT_USER_ENTITY_OVERVIEW = `${MISCONFIGURATION_INSIGHT}-user-entity-overview`;
const VULNERABILITIES_INSIGHT_HOST_DETAILS = exports.VULNERABILITIES_INSIGHT_HOST_DETAILS = `${VULNERABILITIES_INSIGHT}-host-details`;
const VULNERABILITIES_INSIGHT_HOST_ENTITY_OVERVIEW = exports.VULNERABILITIES_INSIGHT_HOST_ENTITY_OVERVIEW = `${VULNERABILITIES_INSIGHT}-host-entity-overview`;
const ENTITY_FLYOUT_WITH_MISCONFIGURATION_VISIT = exports.ENTITY_FLYOUT_WITH_MISCONFIGURATION_VISIT = 'entity-flyout-with-misconfiguration-visits';
const ENTITY_FLYOUT_WITH_VULNERABILITY_PREVIEW = exports.ENTITY_FLYOUT_WITH_VULNERABILITY_PREVIEW = 'entity-flyout-with-vulnerability-preview-visits';
const ENTITY_FLYOUT_EXPAND_MISCONFIGURATION_VIEW_VISITS = exports.ENTITY_FLYOUT_EXPAND_MISCONFIGURATION_VIEW_VISITS = 'entity-flyout-expand-misconfiguration-view-visits';
const ENTITY_FLYOUT_EXPAND_VULNERABILITY_VIEW_VISITS = exports.ENTITY_FLYOUT_EXPAND_VULNERABILITY_VIEW_VISITS = 'entity-flyout-expand-vulnerability-view-visits';
const NAV_TO_FINDINGS_BY_HOST_NAME_FRPOM_ENTITY_FLYOUT = exports.NAV_TO_FINDINGS_BY_HOST_NAME_FRPOM_ENTITY_FLYOUT = 'nav-to-findings-by-host-name-from-entity-flyout';
const NAV_TO_FINDINGS_BY_RULE_NAME_FRPOM_ENTITY_FLYOUT = exports.NAV_TO_FINDINGS_BY_RULE_NAME_FRPOM_ENTITY_FLYOUT = 'nav-to-findings-by-rule-name-from-entity-flyout';
const CREATE_DETECTION_RULE_FROM_FLYOUT = exports.CREATE_DETECTION_RULE_FROM_FLYOUT = 'create-detection-rule-from-flyout';
const CREATE_DETECTION_FROM_TABLE_ROW_ACTION = exports.CREATE_DETECTION_FROM_TABLE_ROW_ACTION = 'create-detection-from-table-row-action';
const VULNERABILITIES_FLYOUT_VISITS = exports.VULNERABILITIES_FLYOUT_VISITS = 'vulnerabilities-flyout-visits';
const OPEN_FINDINGS_FLYOUT = exports.OPEN_FINDINGS_FLYOUT = 'open-findings-flyout';
const GROUP_BY_CLICK = exports.GROUP_BY_CLICK = 'group-by-click';
const CHANGE_RULE_STATE = exports.CHANGE_RULE_STATE = 'change-rule-state';
class UiMetricService {
  constructor() {
    (0, _defineProperty2.default)(this, "usageCollection", void 0);
  }
  setup(usageCollection) {
    this.usageCollection = usageCollection;
  }
  track(metricType, eventName) {
    if (!this.usageCollection) {
      // Usage collection might be disabled in Kibana config.
      return;
    }
    return this.usageCollection.reportUiCounter(APP_NAME, metricType, eventName);
  }
  trackUiMetric(metricType, eventName) {
    return this.track(metricType, eventName);
  }
}
exports.UiMetricService = UiMetricService;
const uiMetricService = exports.uiMetricService = new UiMetricService();