"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractErrorMessage = exports.defaultErrorMessage = exports.buildMutedRulesFilter = exports.buildEntityFlyoutPreviewQuery = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultErrorMessage = exports.defaultErrorMessage = _i18n.i18n.translate('xpack.csp.common.utils.helpers.unknownError', {
  defaultMessage: 'Unknown Error'
});
const extractErrorMessage = (e, fallbackMessage) => {
  if (e instanceof Error) return e.message;
  if (typeof e === 'string') return e;
  return fallbackMessage !== null && fallbackMessage !== void 0 ? fallbackMessage : defaultErrorMessage;
};
exports.extractErrorMessage = extractErrorMessage;
const buildMutedRulesFilter = rulesStates => {
  const mutedRules = Object.fromEntries(Object.entries(rulesStates).filter(([key, value]) => value.muted === true));
  const mutedRulesFilterQuery = Object.keys(mutedRules).map(key => {
    const rule = mutedRules[key];
    return {
      bool: {
        must: [{
          term: {
            'rule.benchmark.id': rule.benchmark_id
          }
        }, {
          term: {
            'rule.benchmark.version': rule.benchmark_version
          }
        }, {
          term: {
            'rule.benchmark.rule_number': rule.rule_number
          }
        }]
      }
    };
  });
  return mutedRulesFilterQuery;
};
exports.buildMutedRulesFilter = buildMutedRulesFilter;
const buildEntityFlyoutPreviewQuery = (field, queryValue) => {
  return {
    bool: {
      filter: [{
        bool: {
          should: [{
            term: {
              [field]: `${queryValue || ''}`
            }
          }],
          minimum_should_match: 1
        }
      }]
    }
  };
};
exports.buildEntityFlyoutPreviewQuery = buildEntityFlyoutPreviewQuery;