"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VULNERABILITIES_SEVERITY = exports.STATUS_ROUTE_PATH = exports.STATUS_API_CURRENT_VERSION = exports.SECURITY_DEFAULT_DATA_VIEW_ID = exports.MAX_FINDINGS_TO_LOAD = exports.LATEST_VULNERABILITIES_RETENTION_POLICY = exports.LATEST_FINDINGS_RETENTION_POLICY = exports.KSPM_POLICY_TEMPLATE = exports.CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH = exports.CSP_GET_BENCHMARK_RULES_STATE_API_CURRENT_VERSION = exports.CSPM_POLICY_TEMPLATE = exports.CLOUD_SECURITY_POSTURE_BASE_PATH = exports.CDR_VULNERABILITIES_INDEX_PATTERN = exports.CDR_MISCONFIGURATIONS_INDEX_PATTERN = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_NAME = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX = exports.CDR_LATEST_THIRD_PARTY_VULNERABILITIES_INDEX_PATTERN = exports.CDR_LATEST_THIRD_PARTY_MISCONFIGURATIONS_INDEX_PATTERN = exports.CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN = exports.CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_PATTERN = exports.CDR_3RD_PARTY_RETENTION_POLICY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KSPM_POLICY_TEMPLATE = exports.KSPM_POLICY_TEMPLATE = 'kspm';
const CSPM_POLICY_TEMPLATE = exports.CSPM_POLICY_TEMPLATE = 'cspm';
const CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_PATTERN = exports.CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_PATTERN = 'logs-cloud_security_posture.findings_latest-default';
const CDR_LATEST_THIRD_PARTY_MISCONFIGURATIONS_INDEX_PATTERN = exports.CDR_LATEST_THIRD_PARTY_MISCONFIGURATIONS_INDEX_PATTERN = 'security_solution-*.misconfiguration_latest';
const CDR_MISCONFIGURATIONS_INDEX_PATTERN = exports.CDR_MISCONFIGURATIONS_INDEX_PATTERN = `${CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_PATTERN},${CDR_LATEST_THIRD_PARTY_MISCONFIGURATIONS_INDEX_PATTERN}`;
const CDR_MISCONFIGURATIONS_DATA_VIEW_NAME = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_NAME = 'Latest Cloud Security Misconfigurations';
const LATEST_FINDINGS_RETENTION_POLICY = exports.LATEST_FINDINGS_RETENTION_POLICY = '26h';
const MAX_FINDINGS_TO_LOAD = exports.MAX_FINDINGS_TO_LOAD = 500;
const CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH = exports.CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH = '/internal/cloud_security_posture/rules/_get_states';
const CSP_GET_BENCHMARK_RULES_STATE_API_CURRENT_VERSION = exports.CSP_GET_BENCHMARK_RULES_STATE_API_CURRENT_VERSION = '1';
const STATUS_ROUTE_PATH = exports.STATUS_ROUTE_PATH = '/internal/cloud_security_posture/status';
const STATUS_API_CURRENT_VERSION = exports.STATUS_API_CURRENT_VERSION = '1';

/** The base path for all cloud security posture pages. */
const CLOUD_SECURITY_POSTURE_BASE_PATH = exports.CLOUD_SECURITY_POSTURE_BASE_PATH = '/cloud_security_posture';
const CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX = 'security_solution_cdr_latest_misconfigurations';
const SECURITY_DEFAULT_DATA_VIEW_ID = exports.SECURITY_DEFAULT_DATA_VIEW_ID = 'security-solution-default';
const CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN = exports.CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN = 'logs-cloud_security_posture.vulnerabilities_latest-default';
const CDR_LATEST_THIRD_PARTY_VULNERABILITIES_INDEX_PATTERN = exports.CDR_LATEST_THIRD_PARTY_VULNERABILITIES_INDEX_PATTERN = 'security_solution-*.vulnerability_latest';
const CDR_VULNERABILITIES_INDEX_PATTERN = exports.CDR_VULNERABILITIES_INDEX_PATTERN = `${CDR_LATEST_THIRD_PARTY_VULNERABILITIES_INDEX_PATTERN},${CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN}`;
const LATEST_VULNERABILITIES_RETENTION_POLICY = exports.LATEST_VULNERABILITIES_RETENTION_POLICY = '3d';

// TODO: remove once https://github.com/elastic/security-team/issues/10801 is done
// meant as a temp workaround to get good enough posture view for 3rd party integrations, see https://github.com/elastic/security-team/issues/10683
const CDR_3RD_PARTY_RETENTION_POLICY = exports.CDR_3RD_PARTY_RETENTION_POLICY = '90d';
const VULNERABILITIES_SEVERITY = exports.VULNERABILITIES_SEVERITY = {
  LOW: 'LOW',
  MEDIUM: 'MEDIUM',
  HIGH: 'HIGH',
  CRITICAL: 'CRITICAL',
  UNKNOWN: 'UNKNOWN'
};