"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeMetadata = initializeMetadata;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @private
 */
function initializeMetadata({
  metadataService,
  initializerContext,
  featureFlags,
  cloud,
  logger
}) {
  var _cloud$serverless;
  const offering = initializerContext.env.packageInfo.buildFlavor;
  metadataService.setup({
    instanceKey: ((_cloud$serverless = cloud.serverless) === null || _cloud$serverless === void 0 ? void 0 : _cloud$serverless.projectId) || cloud.deploymentId,
    offering,
    version: initializerContext.env.packageInfo.version,
    build_num: initializerContext.env.packageInfo.buildNum,
    build_sha: initializerContext.env.packageInfo.buildSha,
    build_sha_short: initializerContext.env.packageInfo.buildShaShort,
    project_type: cloud.serverless.projectType,
    orchestrator_target: cloud.serverless.orchestratorTarget,
    organizationKey: cloud.organizationId,
    trial_end_date: cloud.trialEndDate,
    is_elastic_staff: cloud.isElasticStaffOwned
  });

  // Update the client's contexts when we get any updates in the metadata.
  metadataService.userMetadata$.pipe(
  // Using concatMap to ensure we call the promised update in an orderly manner to avoid concurrency issues
  (0, _rxjs.concatMap)(async userMetadata => {
    try {
      await featureFlags.appendContext(userMetadata);
    } catch (err) {
      logger.warn(`Failed to set the feature flags context ${err}`);
    }
  })).subscribe(); // This subscription will stop when the metadataService stops because it completes the Observable
}