"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineGetPoliciesRoute = exports.PACKAGE_POLICY_SAVED_OBJECT_TYPE = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../common/constants");
var _common = require("../../../common");
var _helpers = require("../../../common/utils/helpers");
var _fleet_util = require("../../lib/fleet_util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PACKAGE_POLICY_SAVED_OBJECT_TYPE = exports.PACKAGE_POLICY_SAVED_OBJECT_TYPE = 'ingest-package-policies';
const createPolicies = (agentPolicies, agentStatusByAgentPolicyId, cloudDefendPackagePolicies) => {
  const cloudDefendPackagePoliciesMap = new Map(cloudDefendPackagePolicies.map(packagePolicy => [packagePolicy.id, packagePolicy]));
  return Promise.all(agentPolicies.flatMap(agentPolicy => {
    var _agentPolicy$package_, _agentPolicy$package_2;
    const cloudDefendPackagesOnAgent = (_agentPolicy$package_ = (_agentPolicy$package_2 = agentPolicy.package_policies) === null || _agentPolicy$package_2 === void 0 ? void 0 : _agentPolicy$package_2.map(({
      id: pckPolicyId
    }) => {
      return cloudDefendPackagePoliciesMap.get(pckPolicyId);
    }).filter(_helpers.isNonNullable)) !== null && _agentPolicy$package_ !== void 0 ? _agentPolicy$package_ : [];
    const policies = cloudDefendPackagesOnAgent.map(async cloudDefendPackage => {
      var _agentStatusByAgentPo;
      const agentPolicyStatus = {
        id: agentPolicy.id,
        name: agentPolicy.name,
        agents: (_agentStatusByAgentPo = agentStatusByAgentPolicyId[agentPolicy.id]) === null || _agentStatusByAgentPo === void 0 ? void 0 : _agentStatusByAgentPo.total
      };
      return {
        package_policy: cloudDefendPackage,
        agent_policy: agentPolicyStatus
      };
    });
    return policies;
  }));
};
const defineGetPoliciesRoute = router => router.versioned.get({
  access: 'internal',
  path: _constants.POLICIES_ROUTE_PATH,
  options: {
    tags: ['access:cloud-defend-read']
  }
}).addVersion({
  version: '1',
  validate: {
    request: {
      query: _common.policiesQueryParamsSchema
    }
  }
}, async (context, request, response) => {
  if (!(await context.fleet).authz.fleet.all) {
    return response.forbidden();
  }
  const cloudDefendContext = await context.cloudDefend;
  try {
    const cloudDefendPackagePolicies = await (0, _fleet_util.getCloudDefendPackagePolicies)(cloudDefendContext.soClient, cloudDefendContext.packagePolicyService, _constants.INTEGRATION_PACKAGE_NAME, request.query);
    const agentPolicies = await (0, _fleet_util.getCloudDefendAgentPolicies)(cloudDefendContext.soClient, cloudDefendPackagePolicies.items, cloudDefendContext.agentPolicyService);
    const agentStatusesByAgentPolicyId = await (0, _fleet_util.getAgentStatusesByAgentPolicies)(cloudDefendContext.agentService, agentPolicies, cloudDefendContext.logger);
    const policies = await createPolicies(agentPolicies, agentStatusesByAgentPolicyId, cloudDefendPackagePolicies.items);
    return response.ok({
      body: {
        ...cloudDefendPackagePolicies,
        items: policies
      }
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cloudDefendContext.logger.error(`Failed to fetch policies ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineGetPoliciesRoute = defineGetPoliciesRoute;