"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudDefendPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../common/constants");
var _loading_state = require("./components/loading_state");
var _setup_context = require("./application/setup_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LazyPolicyReplaceDefineStepExtension = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/fleet_extensions/package_policy_replace_define_step_extension'))));
const LazyCustomAssets = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/fleet_extensions/custom_assets_extension'))));
const RouterLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./application/router'))));
const Router = props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(_loading_state.LoadingState, null)
}, /*#__PURE__*/_react.default.createElement(RouterLazy, props));
class CloudDefendPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
  }
  setup(core, plugins) {
    this.isCloudEnabled = plugins.cloud.isCloudEnabled;

    // Return methods that should be available to other plugins
    return {};
  }
  start(core, plugins) {
    plugins.fleet.registerExtension({
      package: _constants.INTEGRATION_PACKAGE_NAME,
      view: 'package-policy-replace-define-step',
      Component: LazyPolicyReplaceDefineStepExtension
    });
    plugins.fleet.registerExtension({
      package: _constants.INTEGRATION_PACKAGE_NAME,
      view: 'package-detail-assets',
      Component: LazyCustomAssets
    });
    const CloudDefendRouter = props => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...core,
        ...plugins
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: core
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%',
        height: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement(_setup_context.SetupContext.Provider, {
      value: {
        isCloudEnabled: this.isCloudEnabled
      }
    }, /*#__PURE__*/_react.default.createElement(Router, props)))));
    return {
      getCloudDefendRouter: () => CloudDefendRouter
    };
  }
  stop() {}
}
exports.CloudDefendPlugin = CloudDefendPlugin;