"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGeneralViewResponse = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _styles2 = require("../control_general_view_selector/styles");
var i18n = _interopRequireWildcard(require("../control_general_view/translations"));
var _utils = require("../../common/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// max number of names to show in title (in collapsed state)
// selectorA, selectorB, selectorC, selectorD [+5]
const titleThreshold = 4;
const titleThresholdCollapsed = 2;
const ACTION_ID_REGEX = /response_\d+_(.*)/;
const ControlGeneralViewResponse = ({
  response,
  selectors,
  responses,
  index,
  onRemove,
  onDuplicate,
  onChange
}) => {
  var _response$actions, _response$actions2, _response$actions3, _response$exclude3, _response$actions5;
  const {
    euiTheme: {
      colors
    }
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const styles = (0, _styles.useStyles)();
  const selectorStyles = (0, _styles2.useStyles)();
  const visColorsBehindText = (0, _eui.euiPaletteColorBlindBehindText)();
  const [accordionState, setAccordionState] = (0, _react.useState)(responses.length - 1 === index ? 'open' : 'closed');
  const logSelected = (_response$actions = response.actions) === null || _response$actions === void 0 ? void 0 : _response$actions.includes('log');
  const alertSelected = (_response$actions2 = response.actions) === null || _response$actions2 === void 0 ? void 0 : _response$actions2.includes('alert');
  const blockSelected = (_response$actions3 = response.actions) === null || _response$actions3 === void 0 ? void 0 : _response$actions3.includes('block');
  const warnFIMUsingSlashStarStar = (0, _react.useMemo)(() => blockSelected && (0, _utils.selectorsIncludeConditionsForFIMOperationsUsingSlashStarStar)(selectors, response.match), [blockSelected, response.match, selectors]);
  const errors = (0, _react.useMemo)(() => {
    var _response$actions4;
    const errs = {};
    if (response.match.length === 0) {
      errs.match = [i18n.errorValueRequired];
    }
    if (((_response$actions4 = response.actions) === null || _response$actions4 === void 0 ? void 0 : _response$actions4.length) === 0) {
      errs.actions = [i18n.errorActionRequired];
    }
    if (blockSelected) {
      const blockErrors = (0, _utils.validateBlockRestrictions)(selectors, [response]);
      if (blockErrors.length > 0) {
        errs.response = blockErrors;
      }
    }
    return errs;
  }, [response, selectors, blockSelected]);
  const errorList = (0, _react.useMemo)(() => Object.values(errors), [errors]);
  const onResponseChange = (0, _react.useCallback)((resp, i) => {
    if (errorList.length) {
      resp.hasErrors = true;
    }
    onChange(resp, i);
  }, [errorList.length, onChange]);
  (0, _react.useEffect)(() => {
    const hasErrors = errorList.length > 0;
    const changed = hasErrors && !response.hasErrors || !hasErrors && response.hasErrors;
    if (changed) {
      response.hasErrors = hasErrors;
      onChange(response, index);
    }
  }, [errorList.length, index, onChange, response]);
  const onTogglePopover = (0, _react.useCallback)(() => {
    setPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setPopoverOpen(false);
  }, []);
  const onRemoveClicked = (0, _react.useCallback)(() => {
    onRemove(index);
    closePopover();
  }, [closePopover, index, onRemove]);
  const onDuplicateClicked = (0, _react.useCallback)(() => {
    onDuplicate(response);
    closePopover();
  }, [closePopover, onDuplicate, response]);
  const onChangeMatches = (0, _react.useCallback)(options => {
    response.match = options.map(option => option.value);
    onResponseChange(response, index);
  }, [index, onResponseChange, response]);
  const onChangeExcludes = (0, _react.useCallback)(options => {
    var _response$exclude;
    response.exclude = options.map(option => option.value);
    if (((_response$exclude = response.exclude) === null || _response$exclude === void 0 ? void 0 : _response$exclude.length) === 0) {
      delete response.exclude;
    }
    onResponseChange(response, index);
  }, [index, onResponseChange, response]);
  const selectorOptions = (0, _react.useMemo)(() => {
    return selectors.filter(selector => {
      var _response$exclude2;
      return !(selector.type !== response.type || response.match.includes(selector.name) || (_response$exclude2 = response.exclude) !== null && _response$exclude2 !== void 0 && _response$exclude2.includes(selector.name));
    }).map(selector => ({
      label: selector.name,
      value: selector.name
    }));
  }, [response.exclude, response.match, response.type, selectors]);
  const selectedMatches = (0, _react.useMemo)(() => response.match.map(selector => ({
    label: selector,
    value: selector,
    color: visColorsBehindText[0]
  })), [response.match, visColorsBehindText]);
  const selectedExcludes = (0, _react.useMemo)(() => response.exclude && response.exclude.map(selector => ({
    label: selector,
    value: selector,
    color: visColorsBehindText[5]
  })), [response.exclude, visColorsBehindText]);
  const onShowExclude = (0, _react.useCallback)(() => {
    const updatedResponse = {
      ...response
    };
    updatedResponse.exclude = [];
    onResponseChange(updatedResponse, index);
  }, [index, onResponseChange, response]);
  const onToggleAction = (0, _react.useCallback)(e => {
    var _e$currentTarget, _e$currentTarget$id, _e$currentTarget$id$m;
    const action = (_e$currentTarget = e.currentTarget) === null || _e$currentTarget === void 0 ? void 0 : (_e$currentTarget$id = _e$currentTarget.id) === null || _e$currentTarget$id === void 0 ? void 0 : (_e$currentTarget$id$m = _e$currentTarget$id.match(ACTION_ID_REGEX)) === null || _e$currentTarget$id$m === void 0 ? void 0 : _e$currentTarget$id$m[1];
    const updatedResponse = JSON.parse(JSON.stringify(response));
    const actionIndex = updatedResponse.actions.indexOf(action);
    if (actionIndex === -1) {
      updatedResponse.actions.push(action);
    } else {
      // if alert action gets disabled, disable block action
      if (action === 'alert') {
        const blockIndex = updatedResponse.actions.indexOf('block');
        if (blockIndex !== -1) {
          updatedResponse.actions.splice(blockIndex, 1);
        }
      }
      updatedResponse.actions.splice(actionIndex, 1);
    }
    onResponseChange(updatedResponse, index);
  }, [index, onResponseChange, response]);
  const onToggleAccordion = (0, _react.useCallback)(isOpen => {
    setAccordionState(isOpen ? 'open' : 'closed');
  }, []);
  const {
    title,
    plusCount,
    remainingNames
  } = (0, _react.useMemo)(() => {
    if (accordionState === 'open') {
      return {
        title: response.match.slice(0, titleThreshold).join(', '),
        plusCount: response.match.length - titleThreshold,
        remainingNames: response.match.slice(titleThreshold).join(',')
      };
    }
    return {
      title: response.match.slice(0, titleThresholdCollapsed).join(', '),
      plusCount: response.match.length - titleThresholdCollapsed,
      remainingNames: response.match.slice(titleThresholdCollapsed).join(',')
    };
  }, [accordionState, response.match]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: 'response_' + index,
    forceState: accordionState,
    onToggle: onToggleAccordion,
    "data-test-subj": `cloud-defend-${response.type}-response`,
    paddingSize: "m",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.getResponseIconTooltip(response.type)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      type: (0, _utils.getSelectorTypeIcon)(response.type)
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: styles.accordionHeader
    }, /*#__PURE__*/_react.default.createElement("b", null, title), plusCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      title: remainingNames
    }, "+", plusCount)))),
    css: styles.accordion,
    initialIsOpen: index === 0,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      wrap: false
    }, accordionState === 'closed' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      css: selectorStyles.conditionsBadge,
      size: "xs"
    }, (response === null || response === void 0 ? void 0 : (_response$exclude3 = response.exclude) === null || _response$exclude3 === void 0 ? void 0 : _response$exclude3.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("b", null, i18n.exclude, ": "), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      title: response.exclude.join(','),
      color: "hollow"
    }, response.exclude.length), /*#__PURE__*/_react.default.createElement("div", {
      css: selectorStyles.verticalDivider
    })), /*#__PURE__*/_react.default.createElement("b", null, i18n.actions, ": "), (_response$actions5 = response.actions) === null || _response$actions5 === void 0 ? void 0 : _response$actions5.map((action, i) => {
      var _response$actions6;
      return /*#__PURE__*/_react.default.createElement("span", {
        key: action
      }, /*#__PURE__*/_react.default.createElement("b", {
        style: {
          color: action === 'block' ? colors.danger : colors.ink
        }
      }, action[0].toUpperCase() + action.slice(1)), i !== (((_response$actions6 = response.actions) === null || _response$actions6 === void 0 ? void 0 : _response$actions6.length) || 0) - 1 && ', ');
    }), /*#__PURE__*/_react.default.createElement("div", {
      css: selectorStyles.verticalDivider
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "boxesHorizontal",
        onClick: onTogglePopover,
        "aria-label": "Response options",
        "data-test-subj": "cloud-defend-btnresponsepopover"
      }),
      isOpen: isPopoverOpen,
      closePopover: closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downLeft"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "duplicate",
        icon: "copy",
        onClick: onDuplicateClicked,
        "data-test-subj": "cloud-defend-btnduplicateresponse"
      }, i18n.duplicate), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "remove",
        icon: "trash",
        disabled: responses.length < 2,
        onClick: onRemoveClicked,
        "data-test-subj": "cloud-defend-btndeleteresponse"
      }, i18n.remove)]
    }))))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    error: errorList,
    isInvalid: errorList.length > 0
  }, warnFIMUsingSlashStarStar && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: i18n.warningFIMUsingSlashStarStarTitle
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.warningFIMUsingSlashStarStarText))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.matchSelectors,
    fullWidth: true,
    isInvalid: !!errors.match
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": i18n.matchSelectors,
    fullWidth: true,
    selectedOptions: selectedMatches,
    options: selectorOptions,
    isClearable: true,
    onChange: onChangeMatches,
    "data-test-subj": "cloud-defend-responsematch"
  })), response.exclude && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.excludeSelectors,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": i18n.excludeSelectors,
    fullWidth: true,
    selectedOptions: selectedExcludes,
    options: selectorOptions,
    onChange: onChangeExcludes,
    isClearable: true,
    "data-test-subj": "cloud-defend-responseexclude"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !response.exclude && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    onClick: onShowExclude,
    size: "xs",
    "data-test-subj": "cloud-defend-btnshowexclude"
  }, i18n.excludeSelectors), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.actions,
    fullWidth: true,
    isInvalid: !!errors.actions
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: `response_${index}_log`,
    "data-test-subj": "cloud-defend-chklogaction",
    label: i18n.actionLog,
    checked: logSelected,
    onChange: onToggleAction
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: `response_${index}_alert`,
    "data-test-subj": "cloud-defend-chkalertaction",
    label: i18n.actionAlert,
    checked: alertSelected,
    onChange: onToggleAction
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.actionBlockHelp
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: `response_${index}_block`,
    "data-test-subj": "cloud-defend-chkblockaction",
    label: i18n.actionBlock,
    checked: blockSelected,
    onChange: onToggleAction,
    disabled: !alertSelected
  })))))));
};
exports.ControlGeneralViewResponse = ControlGeneralViewResponse;