"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assert = assert;
exports.extractErrorMessage = void 0;
exports.getInputFromPolicy = getInputFromPolicy;
exports.getSelectorsAndResponsesFromYaml = getSelectorsAndResponsesFromYaml;
exports.getYamlFromSelectorsAndResponses = getYamlFromSelectorsAndResponses;
exports.truthy = exports.isNonNullable = exports.isCloudDefendPackage = void 0;
var _jsYaml = _interopRequireDefault(require("js-yaml"));
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @example
 * declare const foo: Array<string | undefined | null>
 * foo.filter(isNonNullable) // foo is Array<string>
 */
const isNonNullable = v => v !== null && v !== undefined;
exports.isNonNullable = isNonNullable;
const truthy = value => !!value;
exports.truthy = truthy;
const extractErrorMessage = (e, defaultMessage = 'Unknown Error') => {
  if (e instanceof Error) return e.message;
  if (typeof e === 'string') return e;
  return defaultMessage; // TODO: i18n
};
exports.extractErrorMessage = extractErrorMessage;
function assert(condition, msg) {
  if (!condition) {
    throw new Error(msg);
  }
}
const isCloudDefendPackage = packageName => packageName === _constants.INTEGRATION_PACKAGE_NAME;
exports.isCloudDefendPackage = isCloudDefendPackage;
function getInputFromPolicy(policy, inputId) {
  return policy.inputs.find(input => input.type === inputId);
}
function getSelectorsAndResponsesFromYaml(configuration) {
  let selectors = [];
  let responses = [];
  try {
    const result = _jsYaml.default.safeLoad(configuration);
    if (result) {
      // iterate selector/response types
      Object.keys(result).forEach(selectorType => {
        const obj = result[selectorType];
        if (obj.selectors) {
          selectors = selectors.concat(obj.selectors.map(selector => ({
            ...selector,
            type: selectorType
          })));
        }
        if (obj.responses) {
          responses = responses.concat(obj.responses.map(response => ({
            ...response,
            type: selectorType
          })));
        }
      });
    }
  } catch {
    // noop
  }
  return {
    selectors,
    responses
  };
}
function getYamlFromSelectorsAndResponses(selectors, responses) {
  const schema = {};
  selectors.reduce((current, selector) => {
    if (current && selector) {
      if (current[selector.type]) {
        var _current$selector$typ;
        (_current$selector$typ = current[selector.type]) === null || _current$selector$typ === void 0 ? void 0 : _current$selector$typ.selectors.push(selector);
      } else {
        current[selector.type] = {
          selectors: [selector],
          responses: []
        };
      }
    }

    // the 'any' cast is used so we can keep 'selector.type' type safe
    delete selector.type;
    return current;
  }, schema);
  responses.reduce((current, response) => {
    if (current && response) {
      if (current[response.type]) {
        current[response.type].responses.push(response);
      } else {
        current[response.type] = {
          selectors: [],
          responses: [response]
        };
      }
    }

    // the 'any' cast is used so we can keep 'response.type' type safe
    delete response.type;
    return current;
  }, schema);
  return _jsYaml.default.safeDump(schema);
}