"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUserAttachment = exports.createFileAttachment = exports.createAlertAttachment = void 0;
var _common = require("@kbn/files-plugin/common");
var _domain = require("../../../common/types/domain");
var _constants = require("../../../common/constants");
var _constants2 = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createUserAttachment = attributes => {
  return {
    id: '1',
    type: _constants.CASE_COMMENT_SAVED_OBJECT,
    attributes: {
      comment: 'Wow, good luck catching that bad meanie!',
      type: _domain.AttachmentType.user,
      created_at: '2019-11-25T21:55:00.177Z',
      created_by: {
        full_name: 'elastic',
        email: 'testemail@elastic.co',
        username: 'elastic'
      },
      owner: _constants.SECURITY_SOLUTION_OWNER,
      pushed_at: null,
      pushed_by: null,
      updated_at: '2019-11-25T21:55:00.177Z',
      updated_by: {
        full_name: 'elastic',
        email: 'testemail@elastic.co',
        username: 'elastic'
      },
      ...attributes
    },
    references: []
  };
};
exports.createUserAttachment = createUserAttachment;
const createAlertAttachment = attributes => {
  return {
    id: '1',
    type: _constants.CASE_COMMENT_SAVED_OBJECT,
    attributes: {
      alertId: 'alert1',
      index: 'index',
      rule: {
        id: 'ruleid',
        name: 'name'
      },
      type: _domain.AttachmentType.alert,
      created_at: '2019-11-25T21:55:00.177Z',
      created_by: {
        full_name: 'elastic',
        email: 'testemail@elastic.co',
        username: 'elastic'
      },
      owner: _constants.SECURITY_SOLUTION_OWNER,
      pushed_at: null,
      pushed_by: null,
      updated_at: '2019-11-25T21:55:00.177Z',
      updated_by: {
        full_name: 'elastic',
        email: 'testemail@elastic.co',
        username: 'elastic'
      },
      ...attributes
    },
    references: []
  };
};
exports.createAlertAttachment = createAlertAttachment;
const fileMetadata = () => ({
  name: 'test_file',
  extension: 'png',
  mimeType: 'image/png',
  created: '2023-02-27T20:26:54.345Z'
});
const fileAttachmentMetadata = () => ({
  files: [fileMetadata()]
});
const getFilesAttachmentReq = () => {
  return {
    type: _domain.AttachmentType.externalReference,
    owner: 'securitySolutionFixture',
    externalReferenceStorage: {
      type: _domain.ExternalReferenceStorageType.savedObject,
      soType: _common.FILE_SO_TYPE
    },
    externalReferenceAttachmentTypeId: _constants.FILE_ATTACHMENT_TYPE,
    externalReferenceMetadata: {
      ...fileAttachmentMetadata
    }
  };
};
const createFileAttachment = attributes => {
  return {
    id: '1',
    type: _constants.CASE_COMMENT_SAVED_OBJECT,
    attributes: {
      ...getFilesAttachmentReq(),
      created_at: '2019-11-25T21:55:00.177Z',
      created_by: {
        full_name: 'elastic',
        email: 'testemail@elastic.co',
        username: 'elastic'
      },
      owner: _constants.SECURITY_SOLUTION_OWNER,
      pushed_at: null,
      pushed_by: null,
      updated_at: '2019-11-25T21:55:00.177Z',
      updated_by: {
        full_name: 'elastic',
        email: 'testemail@elastic.co',
        username: 'elastic'
      },
      ...attributes
    },
    references: [{
      id: 'my-id',
      name: _constants2.EXTERNAL_REFERENCE_REF_NAME,
      type: _common.FILE_SO_TYPE
    }, {
      id: 'caseId',
      name: _constants2.CASE_REF_NAME,
      type: _constants.CASE_SAVED_OBJECT
    }]
  };
};
exports.createFileAttachment = createFileAttachment;