"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchCasesRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchCasesRoute = exports.searchCasesRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: `${_constants.CASES_INTERNAL_URL}/_search`,
  routerOptions: {
    access: 'internal'
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const casesClient = await caseContext.getCasesClient();
      const options = request.body;

      /**
       * throw error if request body does not have owner
       */
      if (!Object.hasOwn(options, 'owner')) {
        throw _boom.default.badRequest('Owner is required.');
      }
      const res = await casesClient.cases.search({
        ...options
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to find cases in route: ${error}`,
        error
      });
    }
  }
});