"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCaseConfigureRoute = void 0;
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCaseConfigureRoute = exports.getCaseConfigureRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'get',
  path: _constants.CASE_CONFIGURE_URL,
  routerOptions: {
    access: 'public',
    summary: 'Get case settings',
    description: 'Retrieves setting details such as the closure type, custom fields, templates, and the default connector for cases.',
    // You must have `read` privileges for the **Cases** feature in the **Management**, **Observability**, or **Security** section of the Kibana feature privileges, depending on where the cases were created.
    tags: ['oas-tag:cases']
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const client = await caseContext.getCasesClient();
      const options = request.query;
      const res = await client.configure.get({
        ...options
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to get case configure in route: ${error}`,
        error
      });
    }
  }
});