"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesKibanaFeature = void 0;
var _i18n = require("@kbn/i18n");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _server = require("@kbn/core/server");
var _common = require("@kbn/features-plugin/common");
var _constants = require("../common/constants");
var _common2 = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The order of appearance in the feature privilege page
 * under the management section. Cases should be under
 * the Actions and Connectors feature
 */

const FEATURE_ORDER = 3100;
const getCasesKibanaFeature = () => {
  const capabilities = (0, _common2.createUICapabilities)();
  const apiTags = (0, _common2.getApiTags)(_constants.APP_ID);
  return {
    id: _constants.FEATURE_ID,
    name: _i18n.i18n.translate('xpack.cases.features.casesFeatureName', {
      defaultMessage: 'Cases'
    }),
    category: _server.DEFAULT_APP_CATEGORIES.management,
    scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
    app: [],
    order: FEATURE_ORDER,
    management: {
      insightsAndAlerting: [_constants.APP_ID]
    },
    cases: [_constants.APP_ID],
    privileges: {
      all: {
        api: apiTags.all,
        cases: {
          create: [_constants.APP_ID],
          read: [_constants.APP_ID],
          update: [_constants.APP_ID],
          push: [_constants.APP_ID]
        },
        management: {
          insightsAndAlerting: [_constants.APP_ID]
        },
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        ui: capabilities.all
      },
      read: {
        api: apiTags.read,
        cases: {
          read: [_constants.APP_ID]
        },
        management: {
          insightsAndAlerting: [_constants.APP_ID]
        },
        savedObject: {
          all: [],
          read: [..._saved_objects.hiddenTypes]
        },
        ui: capabilities.read
      }
    },
    subFeatures: [{
      name: _i18n.i18n.translate('xpack.cases.features.deleteSubFeatureName', {
        defaultMessage: 'Delete'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          api: apiTags.delete,
          id: 'cases_delete',
          name: _i18n.i18n.translate('xpack.cases.features.deleteSubFeatureDetails', {
            defaultMessage: 'Delete cases and comments'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            delete: [_constants.APP_ID]
          },
          ui: capabilities.delete
        }]
      }]
    }, {
      name: _i18n.i18n.translate('xpack.cases.features.casesSettingsSubFeatureName', {
        defaultMessage: 'Case settings'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          id: 'cases_settings',
          name: _i18n.i18n.translate('xpack.cases.features.casesSettingsSubFeatureDetails', {
            defaultMessage: 'Edit case settings'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            settings: [_constants.APP_ID]
          },
          ui: capabilities.settings
        }]
      }]
    }]
  };
};
exports.getCasesKibanaFeature = getCasesKibanaFeature;