"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesConnectorType = exports.getCasesConnectorAdapter = void 0;
var _common = require("@kbn/actions-plugin/common");
var _cases_connector = require("./cases_connector");
var _constants = require("./constants");
var _constants2 = require("../../../common/constants");
var _owner = require("../../../common/utils/owner");
var _schema = require("./schema");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesConnectorType = ({
  getCasesClient,
  getSpaceId,
  getUnsecuredSavedObjectsClient,
  isServerlessSecurity
}) => ({
  id: _constants2.CASES_CONNECTOR_ID,
  name: _constants2.CASES_CONNECTOR_TITLE,
  getService: params => new _cases_connector.CasesConnector({
    casesParams: {
      getCasesClient,
      getSpaceId,
      getUnsecuredSavedObjectsClient
    },
    connectorParams: params
  }),
  schema: {
    config: _schema.CasesConnectorConfigSchema,
    secrets: _schema.CasesConnectorSecretsSchema
  },
  supportedFeatureIds: [_common.UptimeConnectorFeatureId, _common.AlertingConnectorFeatureId, _common.SecurityConnectorFeatureId],
  minimumLicenseRequired: 'platinum',
  isSystemActionType: true,
  getKibanaPrivileges: ({
    params
  } = {
    params: {
      subAction: 'run',
      subActionParams: {}
    }
  }) => {
    var _params$subActionPara, _params$subActionPara2;
    if (!(params !== null && params !== void 0 && (_params$subActionPara = params.subActionParams) !== null && _params$subActionPara !== void 0 && _params$subActionPara.owner)) {
      throw new Error('Cannot authorize cases. Owner is not defined in the subActionParams.');
    }
    const owner = isServerlessSecurity ? _constants2.SECURITY_SOLUTION_OWNER : params === null || params === void 0 ? void 0 : (_params$subActionPara2 = params.subActionParams) === null || _params$subActionPara2 === void 0 ? void 0 : _params$subActionPara2.owner;
    return (0, _utils.constructRequiredKibanaPrivileges)(owner);
  }
});
exports.getCasesConnectorType = getCasesConnectorType;
const getCasesConnectorAdapter = ({
  isServerlessSecurity
}) => {
  return {
    connectorTypeId: _constants2.CASES_CONNECTOR_ID,
    ruleActionParamsSchema: _schema.CasesConnectorRuleActionParamsSchema,
    buildActionParams: ({
      alerts,
      rule,
      params,
      spaceId,
      ruleUrl
    }) => {
      const caseAlerts = [...alerts.new.data, ...alerts.ongoing.data];
      const owner = (0, _owner.getOwnerFromRuleConsumerProducer)({
        consumer: rule.consumer,
        producer: rule.producer,
        isServerlessSecurity
      });
      const subActionParams = {
        alerts: caseAlerts,
        rule: {
          id: rule.id,
          name: rule.name,
          tags: rule.tags,
          ruleUrl: ruleUrl !== null && ruleUrl !== void 0 ? ruleUrl : null
        },
        groupingBy: params.subActionParams.groupingBy,
        owner,
        reopenClosedCases: params.subActionParams.reopenClosedCases,
        timeWindow: params.subActionParams.timeWindow,
        maximumCasesToOpen: _constants.DEFAULT_MAX_OPEN_CASES,
        templateId: params.subActionParams.templateId
      };
      return {
        subAction: 'run',
        subActionParams
      };
    },
    getKibanaPrivileges: ({
      consumer,
      producer
    }) => {
      const owner = (0, _owner.getOwnerFromRuleConsumerProducer)({
        consumer,
        producer,
        isServerlessSecurity
      });
      return (0, _utils.constructRequiredKibanaPrivileges)(owner);
    }
  };
};
exports.getCasesConnectorAdapter = getCasesConnectorAdapter;