"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isReadOnlyPermissions = exports.getAllPermissionsExceptFrom = exports.allCasePermissions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isReadOnlyPermissions = permissions => {
  return !permissions.all && !permissions.create && !permissions.update && !permissions.delete && !permissions.push && permissions.read;
};
exports.isReadOnlyPermissions = isReadOnlyPermissions;
const allCasePermissions = exports.allCasePermissions = ['create', 'read', 'update', 'delete', 'push'];
const getAllPermissionsExceptFrom = capToExclude => allCasePermissions.filter(permission => permission !== capToExclude);
exports.getAllPermissionsExceptFrom = getAllPermissionsExceptFrom;