"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetCasesStatus = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_cases_context = require("../components/cases_context/use_cases_context");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../common/lib/kibana");
var _api = require("../api");
var _use_cases_toast = require("../common/use_cases_toast");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetCasesStatus = () => {
  const http = (0, _kibana.useHttp)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  return (0, _reactQuery.useQuery)(_constants.casesQueriesKeys.casesStatuses(), ({
    signal
  }) => (0, _api.getCasesStatus)({
    http,
    query: {
      owner
    },
    signal
  }), {
    onError: error => {
      showErrorToast(error, {
        title: i18n.ERROR_TITLE
      });
    }
  });
};
exports.useGetCasesStatus = useGetCasesStatus;