"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUserAttachmentUserActionBuilder = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _timestamp = require("../timestamp");
var _markdown_form = require("../markdown_form");
var _content_toolbar = require("../content_toolbar");
var _hoverable_username_resolver = require("../../user_profiles/hoverable_username_resolver");
var _hoverable_avatar_resolver = require("../../user_profiles/hoverable_avatar_resolver");
var _user_comment_property_actions = require("../property_actions/user_comment_property_actions");
var _utils = require("../../markdown_editor/utils");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCommentFooterCss = euiTheme => {
  if (!euiTheme) {
    return (0, _react2.css)``;
  }
  return (0, _react2.css)`
    border-top: ${euiTheme.border.thin};
    padding: ${euiTheme.size.s};
  `;
};
const hasDraftComment = (applicationId = '', caseId, commentId, comment) => {
  const draftStorageKey = (0, _utils.getMarkdownEditorStorageKey)({
    appId: applicationId,
    caseId,
    commentId
  });
  const sessionValue = sessionStorage.getItem(draftStorageKey);
  return Boolean(sessionValue && sessionValue !== comment);
};
const createUserAttachmentUserActionBuilder = ({
  appId,
  comment,
  userProfiles,
  outlined,
  isEdit,
  isLoading,
  commentRefs,
  caseId,
  euiTheme,
  handleManageMarkdownEditId,
  handleSaveComment,
  handleManageQuote,
  handleDeleteComment
}) => ({
  build: () => [{
    username: /*#__PURE__*/_react.default.createElement(_hoverable_username_resolver.HoverableUsernameResolver, {
      user: comment.createdBy,
      userProfiles: userProfiles
    }),
    'data-test-subj': `comment-create-action-${comment.id}`,
    timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
      createdAt: comment.createdAt,
      updatedAt: comment.updatedAt
    }),
    className: (0, _classnames.default)('userAction__comment', {
      outlined,
      isEdit,
      draftFooter: !isEdit && !isLoading && hasDraftComment(appId, caseId, comment.id, comment.comment)
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_markdown_form.UserActionMarkdown, {
      key: isEdit ? comment.id : undefined,
      ref: element => commentRefs.current[comment.id] = element,
      id: comment.id,
      content: comment.comment,
      isEditable: isEdit,
      caseId: caseId,
      onChangeEditable: handleManageMarkdownEditId,
      onSaveContent: handleSaveComment.bind(null, {
        id: comment.id,
        version: comment.version
      })
    }), !isEdit && !isLoading && hasDraftComment(appId, caseId, comment.id, comment.comment) ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: getCommentFooterCss(euiTheme)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      "data-test-subj": "user-action-comment-unsaved-draft"
    }, i18n.UNSAVED_DRAFT_COMMENT)) : ''),
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_hoverable_avatar_resolver.HoverableAvatarResolver, {
      user: comment.createdBy,
      userProfiles: userProfiles
    }),
    actions: /*#__PURE__*/_react.default.createElement(_content_toolbar.UserActionContentToolbar, {
      id: comment.id
    }, /*#__PURE__*/_react.default.createElement(_user_comment_property_actions.UserCommentPropertyActions, {
      isLoading: isLoading,
      commentContent: comment.comment,
      onEdit: () => handleManageMarkdownEditId(comment.id),
      onDelete: () => handleDeleteComment(comment.id, i18n.DELETE_COMMENT_SUCCESS_TITLE),
      onQuote: () => handleManageQuote(comment.comment)
    }))
  }]
});
exports.createUserAttachmentUserActionBuilder = createUserAttachmentUserActionBuilder;