"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Templates = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _experimental_badge = require("../experimental_badge/experimental_badge");
var i18n = _interopRequireWildcard(require("./translations"));
var _templates_list = require("./templates_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TemplatesComponent = ({
  disabled,
  isLoading,
  templates,
  onAddTemplate,
  onEditTemplate,
  onDeleteTemplate
}) => {
  const [error, setError] = (0, _react.useState)(false);
  const handleAddTemplate = (0, _react.useCallback)(() => {
    if (templates.length === _constants.MAX_TEMPLATES_LENGTH && !error) {
      setError(true);
      return;
    }
    onAddTemplate();
    setError(false);
  }, [onAddTemplate, error, templates]);
  const handleEditTemplate = (0, _react.useCallback)(key => {
    setError(false);
    onEditTemplate(key);
  }, [setError, onEditTemplate]);
  const handleDeleteTemplate = (0, _react.useCallback)(key => {
    setError(false);
    onDeleteTemplate(key);
  }, [setError, onDeleteTemplate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, i18n.TEMPLATE_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_experimental_badge.ExperimentalBadge, null))),
    description: /*#__PURE__*/_react.default.createElement("p", null, i18n.TEMPLATE_DESCRIPTION),
    "data-test-subj": "templates-form-group",
    css: {
      alignItems: 'flex-start'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    color: "subdued",
    hasBorder: false,
    hasShadow: false
  }, templates.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_templates_list.TemplatesList, {
    templates: templates,
    onEditTemplate: handleEditTemplate,
    onDeleteTemplate: handleDeleteTemplate
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !templates.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "empty-templates"
  }, i18n.NO_TEMPLATES, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, templates.length < _constants.MAX_TEMPLATES_LENGTH ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isLoading,
    isDisabled: disabled || error,
    size: "s",
    onClick: handleAddTemplate,
    iconType: "plusInCircle",
    "data-test-subj": "add-template"
  }, i18n.ADD_TEMPLATE) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.MAX_TEMPLATE_LIMIT(_constants.MAX_TEMPLATES_LENGTH)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))));
};
TemplatesComponent.displayName = 'Templates';
const Templates = exports.Templates = /*#__PURE__*/_react.default.memo(TemplatesComponent);