"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEKS = exports.TIME_WINDOW_SIZE_ERROR = exports.TIME_WINDOW = exports.REOPEN_WHEN_CASE_IS_CLOSED = exports.GROUP_BY_ALERT = exports.DEFAULT_EMPTY_TEMPLATE_NAME = exports.DAYS = exports.CASE_ACTION_DESC = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASE_ACTION_DESC = exports.CASE_ACTION_DESC = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.selectMessageText', {
  defaultMessage: 'Create a case in Kibana.'
});
const GROUP_BY_ALERT = exports.GROUP_BY_ALERT = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.groupByLabel', {
  defaultMessage: 'Group by alert field'
});
const TIME_WINDOW = exports.TIME_WINDOW = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.timeWindowLabel', {
  defaultMessage: 'Time window'
});
const TIME_WINDOW_SIZE_ERROR = exports.TIME_WINDOW_SIZE_ERROR = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.timeWindowSizeError', {
  defaultMessage: 'Invalid time window.'
});
const REOPEN_WHEN_CASE_IS_CLOSED = exports.REOPEN_WHEN_CASE_IS_CLOSED = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.reopenWhenCaseIsClosed', {
  defaultMessage: 'Reopen when the case is closed'
});
const DAYS = timeValue => _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.daysLabel', {
  defaultMessage: '{timeValue, plural, one {day} other {days}}',
  values: {
    timeValue
  }
});
exports.DAYS = DAYS;
const WEEKS = timeValue => _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.weeksLabel', {
  defaultMessage: '{timeValue, plural, one {week} other {weeks}}',
  values: {
    timeValue
  }
});
exports.WEEKS = WEEKS;
const DEFAULT_EMPTY_TEMPLATE_NAME = exports.DEFAULT_EMPTY_TEMPLATE_NAME = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.defaultEmptyTemplateName', {
  defaultMessage: 'No template selected'
});