"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CasesParamsFieldsComponent = exports.CasesParamsFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_alerts_data_view = require("@kbn/alerts-ui-shared/src/common/hooks/use_alerts_data_view");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../../common/constants");
var _constants2 = require("./constants");
var _utils = require("./utils");
var _kibana = require("../../../common/lib/kibana");
var _templates = require("../../create/templates");
var _owner = require("../../../../common/utils/owner");
var _utils2 = require("../../../containers/configure/utils");
var _use_get_all_case_configurations = require("../../../containers/configure/use_get_all_case_configurations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_EMPTY_TEMPLATE_KEY = 'defaultEmptyTemplateKey';
const CasesParamsFieldsComponent = ({
  actionParams,
  editAction,
  errors,
  index,
  producerId,
  featureId
}) => {
  const {
    cloud,
    data: {
      dataViews: dataViewsService
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const owner = (0, _owner.getOwnerFromRuleConsumerProducer)({
    consumer: featureId,
    producer: producerId,
    // This is a workaround for a very specific bug with the cases action in serverless security
    // More info here: https://github.com/elastic/kibana/issues/195599
    isServerlessSecurity: (cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) && (cloud === null || cloud === void 0 ? void 0 : cloud.serverless.projectType) === 'security'
  });
  const {
    dataView,
    isLoading: loadingAlertDataViews
  } = (0, _use_alerts_data_view.useAlertsDataView)({
    http,
    toasts,
    dataViewsService,
    featureIds: producerId ? [producerId] : []
  });
  const {
    data: configurations,
    isLoading: isLoadingCaseConfiguration
  } = (0, _use_get_all_case_configurations.useGetAllCaseConfigurations)();
  const currentConfiguration = (0, _react.useMemo)(() => (0, _utils2.getConfigurationByOwner)({
    configurations,
    owner
  }), [configurations, owner]);
  const {
    timeWindow,
    reopenClosedCases,
    groupingBy,
    templateId
  } = (0, _react.useMemo)(() => {
    var _actionParams$subActi;
    return (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : {
      timeWindow: `${_constants2.DEFAULT_TIME_WINDOW}`,
      reopenClosedCases: false,
      groupingBy: [],
      templateId: null
    };
  }, [actionParams.subActionParams]);
  const parsedTimeWindowSize = timeWindow.slice(0, timeWindow.length - 1);
  const parsedTimeWindowUnit = timeWindow.slice(-1);
  const timeWindowSize = isNaN(parseInt(parsedTimeWindowSize, 10)) ? _constants2.DEFAULT_TIME_WINDOW[0] : parsedTimeWindowSize.toString();
  const timeWindowUnit = Object.values(_constants2.TIME_UNITS).includes(parsedTimeWindowUnit) ? parsedTimeWindowUnit : _constants2.DEFAULT_TIME_WINDOW[1];
  (0, _react.useEffect)(() => {
    if (!actionParams.subAction) {
      editAction('subAction', _constants.CASES_CONNECTOR_SUB_ACTION.RUN, index);
    }
    if (!actionParams.subActionParams) {
      editAction('subActionParams', {
        timeWindow: `${_constants2.DEFAULT_TIME_WINDOW}`,
        reopenClosedCases: false,
        groupingBy: [],
        templateId: null
      }, index);
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  const editSubActionProperty = (0, _react.useCallback)((key, value) => {
    return editAction('subActionParams', {
      ...actionParams.subActionParams,
      [key]: value
    }, index);
  }, [editAction, index, actionParams.subActionParams]);
  const handleTimeWindowChange = (0, _react.useCallback)((key, value) => {
    if (!value) {
      return;
    }
    const newTimeWindow = key === 'timeWindowSize' ? `${value}${timeWindowUnit}` : `${timeWindowSize}${value}`;
    editSubActionProperty('timeWindow', newTimeWindow);
  }, [editSubActionProperty, timeWindowUnit, timeWindowSize]);
  const onChangeComboBox = (0, _react.useCallback)(optionsValue => {
    editSubActionProperty('groupingBy', optionsValue !== null && optionsValue !== void 0 && optionsValue.length ? [optionsValue[0].value] : []);
  }, [editSubActionProperty]);
  const options = (0, _react.useMemo)(() => {
    if (!dataView) {
      return [];
    }
    return dataView.fields.filter(field => Boolean(field.aggregatable)).map(field => ({
      value: field.name,
      label: field.name
    }));
  }, [dataView]);
  const selectedOptions = groupingBy.map(field => ({
    value: field,
    label: field
  }));
  const selectedTemplate = currentConfiguration.templates.find(t => t.key === templateId);
  const defaultTemplate = {
    key: DEFAULT_EMPTY_TEMPLATE_KEY,
    name: i18n.DEFAULT_EMPTY_TEMPLATE_NAME,
    caseFields: null
  };
  const onTemplateChange = (0, _react.useCallback)(({
    key,
    caseFields
  }) => {
    editSubActionProperty('templateId', key === DEFAULT_EMPTY_TEMPLATE_KEY ? null : key);
  }, [editSubActionProperty]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    isClearable: true,
    singleSelection: true,
    "data-test-subj": "group-by-alert-field-combobox",
    prepend: i18n.GROUP_BY_ALERT,
    isLoading: loadingAlertDataViews,
    isDisabled: loadingAlertDataViews,
    options: options,
    onChange: onChangeComboBox,
    selectedOptions: selectedOptions
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    id: "timeWindow",
    error: errors.timeWindow,
    isInvalid: errors.timeWindow !== undefined && Number(errors.timeWindow.length) > 0 && timeWindow !== undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    prepend: i18n.TIME_WINDOW,
    "data-test-subj": "time-window-size-input",
    value: timeWindowSize,
    min: 1,
    step: 1,
    onChange: e => {
      handleTimeWindowChange('timeWindowSize', e.target.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "time-window-unit-select",
    value: timeWindowUnit,
    onChange: e => {
      handleTimeWindowChange('timeWindowUnit', e.target.value);
    },
    options: (0, _utils.getTimeUnitOptions)(timeWindowSize)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_templates.TemplateSelector, {
    key: currentConfiguration.id,
    isLoading: isLoadingCaseConfiguration,
    templates: [defaultTemplate, ...currentConfiguration.templates],
    onTemplateChange: onTemplateChange,
    initialTemplate: selectedTemplate
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: `reopen-case-${index}`,
    "data-test-subj": "reopen-case",
    checked: reopenClosedCases,
    label: i18n.REOPEN_WHEN_CASE_IS_CLOSED,
    onChange: e => {
      editSubActionProperty('reopenClosedCases', e.target.checked);
    }
  }))));
};
exports.CasesParamsFieldsComponent = CasesParamsFieldsComponent;
CasesParamsFieldsComponent.displayName = 'CasesParamsFields';
const CasesParamsFields = exports.default = exports.CasesParamsFields = /*#__PURE__*/(0, _react.memo)(CasesParamsFieldsComponent);

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export