"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _constants = require("../../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getConnectorType() {
  return {
    id: _constants.CASES_CONNECTOR_ID,
    iconClass: 'casesApp',
    selectMessage: i18n.CASE_ACTION_DESC,
    actionTypeTitle: _constants.CASES_CONNECTOR_TITLE,
    actionConnectorFields: null,
    isExperimental: true,
    validateParams: async actionParams => {
      const errors = {
        timeWindow: []
      };
      const validationResult = {
        errors
      };
      const timeWindowRegex = new RegExp(_constants.CASES_CONNECTOR_TIME_WINDOW_REGEX, 'g');
      if (actionParams.subActionParams && (!actionParams.subActionParams.timeWindow || !actionParams.subActionParams.timeWindow.length || !timeWindowRegex.test(actionParams.subActionParams.timeWindow))) {
        errors.timeWindow.push(i18n.TIME_WINDOW_SIZE_ERROR);
      }
      return validationResult;
    },
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./cases_params')))),
    isSystemActionType: true
  };
}