"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownEditorForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var i18n = _interopRequireWildcard(require("../../common/translations"));
var _editor = require("./editor");
var _context = require("./context");
var _use_markdown_session_storage = require("./use_markdown_session_storage");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable react/no-unused-prop-types */

const MarkdownEditorForm = exports.MarkdownEditorForm = /*#__PURE__*/_react.default.memo( /*#__PURE__*/(0, _react.forwardRef)(({
  id,
  field,
  dataTestSubj,
  idAria,
  bottomRightContent,
  caseTitle,
  caseTags,
  draftStorageKey,
  disabledUiPlugins,
  initialValue
}, ref) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const {
    hasConflicts
  } = (0, _use_markdown_session_storage.useMarkdownSessionStorage)({
    field,
    sessionKey: draftStorageKey !== null && draftStorageKey !== void 0 ? draftStorageKey : '',
    initialValue
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const conflictWarningText = i18n.VERSION_CONFLICT_WARNING(id === 'description' ? id : 'comment');
  const commentEditorContextValue = (0, _react.useMemo)(() => ({
    editorId: id,
    value: field.value,
    caseTitle,
    caseTags
  }), [id, field.value, caseTitle, caseTags]);
  return /*#__PURE__*/_react.default.createElement(_context.CommentEditorContext.Provider, {
    value: commentEditorContextValue
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    fullWidth: true,
    error: errorMessage,
    helpText: field.helpText,
    isInvalid: isInvalid,
    label: field.label,
    labelAppend: field.labelAppend
  }, /*#__PURE__*/_react.default.createElement(_editor.MarkdownEditor, {
    ref: ref,
    ariaLabel: idAria,
    editorId: id,
    onChange: field.setValue,
    value: field.value,
    disabledUiPlugins: disabledUiPlugins,
    "data-test-subj": `${dataTestSubj}-markdown-editor`
  })), bottomRightContent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
                padding: ${euiTheme.size.m} 0;
              `,
    justifyContent: 'flexEnd'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s"
  }, hasConflicts && conflictWarningText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), bottomRightContent)));
}));
MarkdownEditorForm.displayName = 'MarkdownEditorForm';